/**
 * shared_crypto.h
 *
 * Copyright (C) 2004-2005, Joe Testa
 *
 * This software, including this piece of code, is distributed according
 * to the Hacktivismo Software License, as stated in LICENSE.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
  #include "config.h"
#endif

#ifndef SHARED_H
#define SHARED_H



#include <stdio.h>
#include <string.h>

#ifdef _WIN32
   #include <windows.h>
   typedef unsigned int u_int32_t;
#else
   #include <sys/socket.h>
#endif

#include <sys/types.h>
#include <unistd.h>
#include "../src/utils.h"

#define PORT 31337


#ifdef _WIN32
   int handle_chat(SOCKET fd);
   DWORD WINAPI read_thread(void *ptr);

   void handle_fingerprint(SOCKET socket, char *who, char *fingerprint);
   int get_message(SOCKET socket, char *who, char *raw_message,
		   size_t raw_message_len);
   void send_message(SOCKET socket, char *who, char *message);
#else
   int handle_chat(int fd);
   void handle_fingerprint(int socket, char *who, char *fingerprint);
   int get_message(int socket, char *who, char *raw_message,
		   size_t raw_message_len);
   void send_message(int socket, char *who, char *message);
#endif

void mod_kill(void);
void console_read_line(char *buffer, size_t buffer_len);
size_t get_sizes(size_t *size_array, size_t size_array_len);
void init_module(void);
void mod_write(char *string);
void mod_writeln(char *string);
int mod_readdata(char *buffer, size_t buffer_len, size_t bytes_to_read);
int mod_readline(char *buffer, size_t buffer_len);
int parseOK(char *line, unsigned int *type, unsigned int *num_results);
void readcrlf(void);
void run_module(void);
void show_usage_and_die(char *prog);
void trim_crlf(char *buffer);
void noop(char *title);
/*void my_sleep(int ms);*/


char load_save_dir[ 256 ];
void reset_module(void);
void shutdown_module(void);

#endif
