/**
 * shared_normal.h
 *
 * Copyright (C) 2004-2005, Joe Testa
 *
 * This software, including this piece of code, is distributed according
 * to the Hacktivismo Software License, as stated in LICENSE.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef SHARED_H
#define SHARED_H

#include "../src/utils.h"
#include <stdio.h>
#include <string.h>
#ifdef _WIN32
   #include <windows.h>
   #include <winsock2.h>
   typedef unsigned int u_int32_t;
#else
   #include <sys/socket.h>
#endif
#include <sys/types.h>
#include <unistd.h>

#define PORT 31337

void console_read_line(char *buffer, size_t buffer_len);
void show_usage_and_die(char *prog);

#ifdef _WIN32
   void handle_chat(SOCKET fd);
   int get_message(SOCKET socket, char *buffer, size_t buf_size);
   void send_message(SOCKET socket, char *message);
   DWORD WINAPI read_thread(void *nothing);
#else
   void handle_chat(int fd);
   int get_message(int socket, char *buffer, size_t buf_size);
   void send_message(int socket, char *message);
#endif

#endif
