/*
WASTE - wxWidgets main application class
Copyright (C) 2005 WASTE Development Team

WASTE is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

WASTE  is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with WASTE; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if defined(__GNUG__) && !defined(__APPLE__)
#pragma implementation "wxmain.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "wxmain.h"
#include <wx/string.h>
#include <wx/textdlg.h>
#include <wx/treectrl.h>
#include "main.hpp"

////@begin XPM images
////@end XPM images

/*!
* Application instance implementation
*/

////@begin implement app
IMPLEMENT_APP( WxwasteApp )
////@end implement app

/*!
* WxwasteApp type definition
*/

IMPLEMENT_CLASS( WxwasteApp, wxApp )

/*!
* WxwasteApp event table definition
*/

BEGIN_EVENT_TABLE( WxwasteApp, wxApp )

////@begin WxwasteApp event table entries
////@end WxwasteApp event table entries

END_EVENT_TABLE()

/*!
* Constructor for WxwasteApp
*/

WxwasteApp::WxwasteApp()
{
////@begin WxwasteApp member initialisation
////@end WxwasteApp member initialisation
}

/*!
* Initialisation for WxwasteApp
*/

bool WxwasteApp::OnInit()
{
	wxXmlResource::Get()->InitAllHandlers();
	//wxXmlResource::Get()->Load( wxT("wxwaste.xrc") );

	extern void InitXmlResource();
	InitXmlResource();

#if wxUSE_XPM
	wxImage::AddHandler( new wxXPMHandler );
#endif
#if wxUSE_LIBPNG
	wxImage::AddHandler( new wxPNGHandler );
#endif
#if wxUSE_LIBJPEG
	wxImage::AddHandler( new wxJPEGHandler );
#endif
#if wxUSE_GIF
	wxImage::AddHandler( new wxGIFHandler );
#endif

	// annoying.  wxWindows has taken over argc/argv and made
	// them into Unicode strings.  recreate them
	char **argv_str_copy = (char **) malloc(sizeof(char *) * wxApp::argc);
	// we never free this, since it's traditional under UNIX
	// that argv remains valid until exit()
	int i;
	for (i = 0; i < wxApp::argc; i++) {
#if wxUSE_UNICODE
	// ugh! it's a wxChar*
	argv_str_copy[i] = strdup (wxConvCurrent->cWX2MB(wxApp::argv[i]));
#else
	argv_str_copy[i] = strdup (wxApp::argv[i]);
#endif
	}

	if (waste_main_start(wxApp::argc, argv_str_copy) != 0) {
		return false;
	}

	MainFrame* mainWindow = new MainFrame( NULL, ID_MAIN_FRAME );
	mainWindow->Show(true);
	
	m_mainframe = mainWindow;

	return true;
}

/*!
* Cleanup for WxwasteApp
*/
int WxwasteApp::OnExit()
{    
	//waste_main_exit();
	
////@begin WxwasteApp cleanup
	return wxApp::OnExit();
////@end WxwasteApp cleanup
}

int WxwasteApp::MainLoop()
{
	return wxApp::MainLoop();
}


void
wx_get_key_password(char *buf, int len) {
	wxString str;
	str = wxGetPasswordFromUser(
			_T("Please enter WASTE private key password"),
			_T("WASTE Password"));

	safe_strncpy(buf, (char *) str.c_str(), len - 1);
}

void
wxSetDlgItemText(wxObject *ptr, const char *buf) {
	wxString str = cstr_to_wxstr(buf);
	if (ptr->IsKindOf(CLASSINFO(wxTextCtrl))) {
		wxDynamicCast(ptr, wxTextCtrl)->SetValue(str);
	}
	else if (ptr->IsKindOf(CLASSINFO(wxComboBox))) {
		wxDynamicCast(ptr, wxComboBox)->SetValue(str);
	}
	else if (ptr->IsKindOf(CLASSINFO(wxStaticText))) {
		wxDynamicCast(ptr, wxStaticText)->SetLabel(str);
	}
	else {
		wxLogError (_T("wxSetDlgItemText doesn't support this type (%lx)"), (long) ptr);
	}
}

void
wxGetDlgItemText(wxObject *ptr, char *buf, int len) {
	wxString str;
	if (ptr->IsKindOf(CLASSINFO(wxTextCtrl))) {
		str = wxDynamicCast(ptr, wxTextCtrl)->GetValue();
	}
	else if (ptr->IsKindOf(CLASSINFO(wxComboBox))) {
		str = wxDynamicCast(ptr, wxComboBox)->GetValue();
	}
	else if (ptr->IsKindOf(CLASSINFO(wxStaticText))) {
		str = wxDynamicCast(ptr, wxStaticText)->GetLabel();
	}
	else {
		wxLogError (_T("wxGetDlgItemText doesn't support this type (%lx)"), (long) ptr);
		*buf = '\0';
		return;
	}
	wxstr_to_cstr(buf, str, len);
}

bool
showTreeCtrlContextMenu (wxTreeCtrl *tree, wxMenu *menu, wxPoint pt, bool is_screen) {
	// this is from the wxWidgets "treectrl" example
	// check if event was generated by keyboard (MSW-specific?)
	if (pt.x==-1 && pt.y==-1) //(this is how MSW indicates it)
	{
		//attempt to guess where to show the menu
		wxTreeItemId item = tree->GetSelection();
		if (item.IsOk()) {
			//if an item was clicked, show menu to the right of it
			wxRect rect;
			tree->GetBoundingRect(item, rect, true); //true = only the label
			pt = wxPoint(rect.GetRight(), rect.GetTop());
		} else {
			pt = wxPoint(0, 0);
		}
	}
	else
	{
		// event was generated by mouse, use supplied coords
		if (is_screen) {
			pt = tree->ScreenToClient(pt);
		}

		// select the item under the mouse ptr 
		int hitflags = (wxTREE_HITTEST_ONITEMBUTTON|wxTREE_HITTEST_ONITEMICON|
				wxTREE_HITTEST_ONITEMINDENT|wxTREE_HITTEST_ONITEMLABEL|
				wxTREE_HITTEST_ONITEMRIGHT|wxTREE_HITTEST_ONITEMSTATEICON);

		wxTreeItemId id = tree->HitTest(pt, hitflags);
		if (hitflags) {
			tree->SelectItem(id, true);
		}
	}

	return tree->PopupMenu(menu, pt);
}

