/*
 * wipe_file - Simple Nomad <thegnome@nmrc.org>
 *
 * 21Apr2003 - Added fsync after each write, and randomly shuffled the
 *             27 passes. Todd MacDermid <tmacd@synacklabs.net>
 */

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include "rand_gen.h" 
#include "wipe_file.h"

/*
 * securely erase a file, using Peter Gutmann's overwrite techniques, 
 * total of 27 passes. Must shuffle randomly the 27 set passes.
 */
int wipe_file(char *filename)
{
	unsigned char raw_wipe[27][3] =
	{{0x55,0x55,0x55}, {0xaa,0xaa,0xaa}, {0x92,0x49,0x24}, {0x49,0x24,0x92},
	{0x24,0x92,0x49}, {0x00,0x00,0x00}, {0x11,0x11,0x11}, {0x22,0x22,0x22},
	{0x33,0x33,0x33}, {0x44,0x44,0x44}, {0x55,0x55,0x55}, {0x66,0x66,0x66},
	{0x77,0x77,0x77}, {0x88,0x88,0x88}, {0x99,0x99,0x99}, {0xaa,0xaa,0xaa},
	{0xbb,0xbb,0xbb}, {0xcc,0xcc,0xcc}, {0xdd,0xdd,0xdd}, {0xee,0xee,0xee},
	{0xff,0xff,0xff}, {0x92,0x49,0x24}, {0x49,0x24,0x92}, {0x24,0x92,0x49},
	{0x6d,0xb6,0xdb}, {0xb6,0xdb,0x6d}, {0xdb,0x6d,0xb6}};
		      
	FILE *fpin = NULL;
	int fd;
	int deck[27];
	struct stat statbuf;
	unsigned char wipeMaterial[256];
	int i,j,k,blocks,extra,temp;

	if(stat(filename,&statbuf) == -1) return (FILE_NOT_FOUND);
	if((fpin=fopen(filename, "r+")) == NULL) return (FILE_NOT_WRITEABLE);
	i = (int)statbuf.st_size;
	fd = fileno(fpin);
	if(seed_rand_num() == -1) return (SEED_ERR);

	/* determine number of 256 byte blocks, plus the extra (if any) */
	extra = i % 256;
	blocks = (i - extra) / 256;

	/* 4 passes with each pass wiping with random data */
	for(i=0;i<4;i++)
	{
		rewind(fpin);
		/* wipe with random data */
		for(j=0;j<blocks;j++)
		{
			gen_rand_mat(&wipeMaterial[0],256);
			if(fwrite(wipeMaterial,256,1,fpin)!=1) return(FILE_ERR);
		}
		if(extra)
		{
			gen_rand_mat(&wipeMaterial[0],extra);
			if(fwrite(wipeMaterial,extra,1,fpin)!=1) return(FILE_ERR);
		}
		fsync(fd);
	}

	/* set and shuffle the deck */
	for(i=0;i<27;i++)
	{
		deck[i] = i;
	}
	for(i=0;i<27;i++)
	{
		deck[i] = deck[get_rand_num(R_UNSIGNEDLONG) % 27];
		j = get_rand_num(R_UNSIGNEDLONG) % 27;
		temp = deck[i];
		deck[i] = deck[j];
		deck[j] = temp;
	}
	
	/* 27 passes with data to thwart forensic recovery */
	for(i=0;i<27;i++)
	{
		k = deck[i];
		rewind(fpin);
		extend_mat(raw_wipe[k],&wipeMaterial[0],256);
		for(j=0;j<blocks;j++)
			if(fwrite(wipeMaterial,256,1,fpin)!=1) return(FILE_ERR);
		if(extra)
		{
			if(extra<3)
				for(j=0;j<extra;j++)
					wipeMaterial[j] = raw_wipe[k][j];
			else extend_mat(raw_wipe[i],&wipeMaterial[0],extra);
			if(fwrite(wipeMaterial,extra,1,fpin)!=1) return(FILE_ERR);
		}
		fsync(fd);
	}

	/* 4 more passes with random data */
	for(i=0;i<4;i++)
	{
		rewind(fpin);
		/* wipe with random data */
		for(j=0;j<blocks;j++)
		{
			gen_rand_mat(&wipeMaterial[0],256);
			if(fwrite(wipeMaterial,256,1,fpin)!=1) return(FILE_ERR);
		}
		if(extra)
		{
			gen_rand_mat(&wipeMaterial[0],extra);
			if(fwrite(wipeMaterial,extra,1,fpin)!=1) return(FILE_ERR);
		}
		fsync(fd);
	}
	fclose(fpin);
	remove(filename);
	return(SUCCESS); 
}
