#include "ncrypt.h"
#include "encrypt_file.h"

void encrypt_file(FILE* ifp, FILE* ofp)
{
    BYTE block[4 * 4];
    int size = 0;
    while (1)
    {
        guaranteed_memset(block, 0, 16);
        size = fread(block, 1, 16, ifp);
        if (size <= 0) break;
        if (ARGS.rijndael_given) blockEncryptR(&cipherInst,  &keyInstR, block, 128, block);
        if (ARGS.serpent_given)  blockEncryptS(&cipherInst,  &keyInstS, block, 128, block);
        if (ARGS.twofish_given)  blockEncryptT(&cipherInstT, &keyInstT, block, 128, block);
        /* note that on the last block, we are padding to 16 bytes */
        if (fwrite(block, 16, 1, ofp) != 1)
        {
            fprintf(stderr,"** ERROR writing data\n");
            exit(-1);
        }
    }
}

