#include "ncrypt.h"
#include "decrypt_file.h"

void decrypt_file(FILE* ifp, int fsize, FILE* ofp, int algo)
{
    BYTE block[4 * 4];
    int i, writesize = 0, size = 0;

    while (fsize > 0)
    {
        guaranteed_memset(block, 0, 16);
        size = fread(block, 1, 16, ifp);
        if (size <= 0) break;
        switch(algo)
        {
          case RIJNDAEL: 
            blockDecryptR(&cipherInst, &keyInstR, block, 128, block);
            break;
          case SERPENT:
            blockDecryptS(&cipherInst, &keyInstS, block, 128, block);
            break;
          case TWOFISH:
            blockDecryptT(&cipherInstT, &keyInstT, block, 128, block);
            break;
        }
        /* on last block, eliminate the padding if it exists */
        if(fsize == 16)
        {
            for(i=0; i<16; i++)
            if(block[i] != 0) writesize = i+1;
        }
        else writesize = 16;
        if (fwrite(block, writesize, 1, ofp) != 1)
        {
            fprintf(stderr,"** ERROR writing data\n");
            exit(-1);
        }
        if (writesize != 16) break;
        fsize -= size;
    }
}

