/* ssl/ssl3.h */
/* Copyright (C) 1995-1998 Eric Young (eay@cryptsoft.com)
 * All rights reserved.
 *
 * This package is an SSL implementation written
 * by Eric Young (eay@cryptsoft.com).
 * The implementation was written so as to conform with Netscapes SSL.
 * 
 * This library is free for commercial and non-commercial use as long as
 * the following conditions are aheared to.  The following conditions
 * apply to all code found in this distribution, be it the RC4, RSA,
 * lhash, DES, etc., code; not just the SSL code.  The SSL documentation
 * included with this distribution is covered by the same copyright terms
 * except that the holder is Tim Hudson (tjh@cryptsoft.com).
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * If this package is used in a product, Eric Young should be given attribution
 * as the author of the parts of the library used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    "This product includes cryptographic software written by
 *     Eric Young (eay@cryptsoft.com)"
 *    The word 'cryptographic' can be left out if the rouines from the library
 *    being used are not cryptographic related :-).
 * 4. If you include any Windows specific code (or a derivative thereof) from 
 *    the apps directory (application code) you must include an acknowledgement:
 *    "This product includes software written by Tim Hudson (tjh@cryptsoft.com)"
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#ifndef HEADER_SSL3_H 
#define HEADER_SSL3_H 

#include "buffer.h"

#ifdef  __cplusplus
extern "C" {
#endif

#define SSL3_CK_RSA_NULL_MD5			0x03000001
#define SSL3_CK_RSA_NULL_SHA			0x03000002
#define SSL3_CK_RSA_RC4_40_MD5 			0x03000003
#define SSL3_CK_RSA_RC4_128_MD5			0x03000004
#define SSL3_CK_RSA_RC4_128_SHA			0x03000005
#define SSL3_CK_RSA_RC2_40_MD5			0x03000006
#define SSL3_CK_RSA_IDEA_128_SHA		0x03000007
#define SSL3_CK_RSA_DES_40_CBC_SHA		0x03000008
#define SSL3_CK_RSA_DES_64_CBC_SHA		0x03000009
#define SSL3_CK_RSA_DES_192_CBC3_SHA		0x0300000A

#define SSL3_CK_DH_DSS_DES_40_CBC_SHA		0x0300000B
#define SSL3_CK_DH_DSS_DES_64_CBC_SHA		0x0300000C
#define SSL3_CK_DH_DSS_DES_192_CBC3_SHA 	0x0300000D
#define SSL3_CK_DH_RSA_DES_40_CBC_SHA		0x0300000E
#define SSL3_CK_DH_RSA_DES_64_CBC_SHA		0x0300000F
#define SSL3_CK_DH_RSA_DES_192_CBC3_SHA 	0x03000010

#define SSL3_CK_EDH_DSS_DES_40_CBC_SHA		0x03000011
#define SSL3_CK_EDH_DSS_DES_64_CBC_SHA		0x03000012
#define SSL3_CK_EDH_DSS_DES_192_CBC3_SHA	0x03000013
#define SSL3_CK_EDH_RSA_DES_40_CBC_SHA		0x03000014
#define SSL3_CK_EDH_RSA_DES_64_CBC_SHA		0x03000015
#define SSL3_CK_EDH_RSA_DES_192_CBC3_SHA	0x03000016

#define SSL3_CK_ADH_RC4_40_MD5			0x03000017
#define SSL3_CK_ADH_RC4_128_MD5			0x03000018
#define SSL3_CK_ADH_DES_40_CBC_SHA		0x03000019
#define SSL3_CK_ADH_DES_64_CBC_SHA		0x0300001A
#define SSL3_CK_ADH_DES_192_CBC_SHA		0x0300001B

#define SSL3_CK_FZA_DMS_NULL_SHA		0x0300001C
#define SSL3_CK_FZA_DMS_FZA_SHA			0x0300001D
#define SSL3_CK_FZA_DMS_RC4_SHA			0x0300001E

#define SSL3_TXT_RSA_NULL_MD5			"NULL-MD5"
#define SSL3_TXT_RSA_NULL_SHA			"NULL-SHA"
#define SSL3_TXT_RSA_RC4_40_MD5 		"EXP-RC4-MD5"
#define SSL3_TXT_RSA_RC4_128_MD5		"RC4-MD5"
#define SSL3_TXT_RSA_RC4_128_SHA		"RC4-SHA"
#define SSL3_TXT_RSA_RC2_40_MD5			"EXP-RC2-CBC-MD5"
#define SSL3_TXT_RSA_IDEA_128_SHA		"IDEA-CBC-SHA"
#define SSL3_TXT_RSA_DES_40_CBC_SHA		"EXP-DES-CBC-SHA"
#define SSL3_TXT_RSA_DES_64_CBC_SHA		"DES-CBC-SHA"
#define SSL3_TXT_RSA_DES_192_CBC3_SHA		"DES-CBC3-SHA"

#define SSL3_TXT_DH_DSS_DES_40_CBC_SHA		"EXP-DH-DSS-DES-CBC-SHA"
#define SSL3_TXT_DH_DSS_DES_64_CBC_SHA		"DH-DSS-DES-CBC-SHA"
#define SSL3_TXT_DH_DSS_DES_192_CBC3_SHA 	"DH-DSS-DES-CBC3-SHA"
#define SSL3_TXT_DH_RSA_DES_40_CBC_SHA		"EXP-DH-RSA-DES-CBC-SHA"
#define SSL3_TXT_DH_RSA_DES_64_CBC_SHA		"DH-RSA-DES-CBC-SHA"
#define SSL3_TXT_DH_RSA_DES_192_CBC3_SHA 	"DH-RSA-DES-CBC3-SHA"

#define SSL3_TXT_EDH_DSS_DES_40_CBC_SHA		"EXP-EDH-DSS-DES-CBC-SHA"
#define SSL3_TXT_EDH_DSS_DES_64_CBC_SHA		"EDH-DSS-DES-CBC-SHA"
#define SSL3_TXT_EDH_DSS_DES_192_CBC3_SHA	"EDH-DSS-DES-CBC3-SHA"
#define SSL3_TXT_EDH_RSA_DES_40_CBC_SHA		"EXP-EDH-RSA-DES-CBC-SHA"
#define SSL3_TXT_EDH_RSA_DES_64_CBC_SHA		"EDH-RSA-DES-CBC-SHA"
#define SSL3_TXT_EDH_RSA_DES_192_CBC3_SHA	"EDH-RSA-DES-CBC3-SHA"

#define SSL3_TXT_ADH_RC4_40_MD5			"EXP-ADH-RC4-MD5"
#define SSL3_TXT_ADH_RC4_128_MD5		"ADH-RC4-MD5"
#define SSL3_TXT_ADH_DES_40_CBC_SHA		"EXP-ADH-DES-CBC-SHA"
#define SSL3_TXT_ADH_DES_64_CBC_SHA		"ADH-DES-CBC-SHA"
#define SSL3_TXT_ADH_DES_192_CBC_SHA		"ADH-DES-CBC3-SHA"

#define SSL3_TXT_FZA_DMS_NULL_SHA		"FZA-NULL-SHA"
#define SSL3_TXT_FZA_DMS_FZA_SHA		"FZA-FZA-CBC-SHA"
#define SSL3_TXT_FZA_DMS_RC4_SHA		"FZA-RC4-SHA"

#define SSL3_SSL_SESSION_ID_LENGTH		32
#define SSL3_MAX_SSL_SESSION_ID_LENGTH		32

#define SSL3_MASTER_SECRET_SIZE			48
#define SSL3_RANDOM_SIZE			32
#define SSL3_SESSION_ID_SIZE			32
#define SSL3_RT_HEADER_LENGTH			5

/* Due to MS stuffing up, this can change.... */
#if defined(WIN16) || (defined(MSDOS) && !defined(WIN32))
#define SSL3_RT_MAX_EXTRA			(14000)
#else
#define SSL3_RT_MAX_EXTRA			(16384)
#endif

#define SSL3_RT_MAX_PLAIN_LENGTH		16384
#define SSL3_RT_MAX_COMPRESSED_LENGTH	(1024+SSL3_RT_MAX_PLAIN_LENGTH)
#define SSL3_RT_MAX_ENCRYPTED_LENGTH	(1024+SSL3_RT_MAX_COMPRESSED_LENGTH)
#define SSL3_RT_MAX_PACKET_SIZE		(SSL3_RT_MAX_ENCRYPTED_LENGTH+SSL3_RT_HEADER_LENGTH)
#define SSL3_RT_MAX_DATA_SIZE			(1024*1024)

/* the states that a SSL3_RECORD can be in
 * For SSL_read it goes
 * rbuf->ENCODED	-> read 
 * ENCODED		-> we need to decode everything - call decode_record
 */
 
#define SSL3_RS_BLANK			1
#define SSL3_RS_DATA

#define SSL3_RS_ENCODED			2
#define SSL3_RS_READ_MORE		3
#define SSL3_RS_WRITE_MORE
#define SSL3_RS_PLAIN			3
#define SSL3_RS_PART_READ		4
#define SSL3_RS_PART_WRITE		5

#define SSL3_MD_CLIENT_FINISHED_CONST	{0x43,0x4C,0x4E,0x54}
#define SSL3_MD_SERVER_FINISHED_CONST	{0x53,0x52,0x56,0x52}

#define SSL3_VERSION			0x0300
#define SSL3_VERSION_MAJOR		0x03
#define SSL3_VERSION_MINOR		0x00

#define SSL3_RT_CHANGE_CIPHER_SPEC	20
#define SSL3_RT_ALERT			21
#define SSL3_RT_HANDSHAKE		22
#define SSL3_RT_APPLICATION_DATA	23

#define SSL3_AL_WARNING			1
#define SSL3_AL_FATAL			2

#define SSL3_AD_CLOSE_NOTIFY		 0
#define SSL3_AD_UNEXPECTED_MESSAGE	10	/* fatal */
#define SSL3_AD_BAD_RECORD_MAC		20	/* fatal */
#define SSL3_AD_DECOMPRESSION_FAILURE	30	/* fatal */
#define SSL3_AD_HANDSHAKE_FAILURE	40	/* fatal */
#define SSL3_AD_NO_CERTIFICATE		41
#define SSL3_AD_BAD_CERTIFICATE		42
#define SSL3_AD_UNSUPPORTED_CERTIFICATE	43
#define SSL3_AD_CERTIFICATE_REVOKED	44
#define SSL3_AD_CERTIFICATE_EXPIRED	45
#define SSL3_AD_CERTIFICATE_UNKNOWN	46
#define SSL3_AD_ILLEGAL_PARAMETER	47	/* fatal */

typedef struct ssl3_record_st
	{
/*r */	int type;		/* type of record */
/*  */	/*int state;*/		/* any data in it? */
/*rw*/	unsigned int length;	/* How many bytes available */
/*r */	unsigned int off;	/* read/write offset into 'buf' */
/*rw*/	unsigned char *data;	/* pointer to the record data */
/*rw*/	unsigned char *input;	/* where the decode bytes are */
/*r */	unsigned char *comp;	/* only used with decompression - malloc()ed */
	} SSL3_RECORD;

typedef struct ssl3_buffer_st
	{
/*r */	int total;		/* used in non-blocking writes */
/*r */	int wanted;		/* how many more bytes we need */
/*rw*/	int left;		/* how many bytes left */
/*rw*/	int offset;		/* where to 'copy from' */
/*rw*/	unsigned char *buf;	/* SSL3_RT_MAX_PACKET_SIZE bytes */
	} SSL3_BUFFER;

#define SSL3_CT_RSA_SIGN			1
#define SSL3_CT_DSS_SIGN			2
#define SSL3_CT_RSA_FIXED_DH			3
#define SSL3_CT_DSS_FIXED_DH			4
#define SSL3_CT_RSA_EPHEMERAL_DH		5
#define SSL3_CT_DSS_EPHEMERAL_DH		6
#define SSL3_CT_FORTEZZA_DMS			20
#define SSL3_CT_NUMBER				7

#define SSL3_FLAGS_NO_RENEGOTIATE_CIPHERS	0x0001
#define SSL3_FLAGS_DELAY_CLIENT_FINISHED	0x0002
#define SSL3_FLAGS_POP_BUFFER			0x0004
#define TLS1_FLAGS_TLS_PADDING_BUG		0x0008

#if 0
#define AD_CLOSE_NOTIFY			0
#define AD_UNEXPECTED_MESSAGE		1
#define AD_BAD_RECORD_MAC		2
#define AD_DECRYPTION_FAILED		3
#define AD_RECORD_OVERFLOW		4
#define AD_DECOMPRESSION_FAILURE	5	/* fatal */
#define AD_HANDSHAKE_FAILURE		6	/* fatal */
#define AD_NO_CERTIFICATE		7	/* Not under TLS */
#define AD_BAD_CERTIFICATE		8
#define AD_UNSUPPORTED_CERTIFICATE	9
#define AD_CERTIFICATE_REVOKED		10	
#define AD_CERTIFICATE_EXPIRED		11
#define AD_CERTIFICATE_UNKNOWN		12
#define AD_ILLEGAL_PARAMETER		13	/* fatal */
#define AD_UNKNOWN_CA			14	/* fatal */
#define AD_ACCESS_DENIED		15	/* fatal */
#define AD_DECODE_ERROR			16	/* fatal */
#define AD_DECRYPT_ERROR		17
#define AD_EXPORT_RESTRICION		18	/* fatal */
#define AD_PROTOCOL_VERSION		19	/* fatal */
#define AD_INSUFFICIENT_SECURITY	20	/* fatal */
#define AD_INTERNAL_ERROR		21	/* fatal */
#define AD_USER_CANCLED			22
#define AD_NO_RENEGOTIATION		23
#endif

typedef struct ssl3_ctx_st
	{
	long flags;
	int delay_buf_pop_ret;

	unsigned char read_sequence[8];
	unsigned char read_mac_secret[EVP_MAX_MD_SIZE];
	unsigned char write_sequence[8];
	unsigned char write_mac_secret[EVP_MAX_MD_SIZE];

	unsigned char server_random[SSL3_RANDOM_SIZE];
	unsigned char client_random[SSL3_RANDOM_SIZE];

	SSL3_BUFFER rbuf;	/* read IO goes into here */
	SSL3_BUFFER wbuf;	/* write IO goes into here */
	SSL3_RECORD rrec;	/* each decoded record goes in here */
	SSL3_RECORD wrec;	/* goes out from here */
				/* Used by ssl3_read_n to point
				 * to input data packet */

	/* partial write - check the numbers match */
	unsigned int wnum;	/* number of bytes sent so far */
	int wpend_tot;		/* number bytes written */
	int wpend_type;
	int wpend_ret;		/* number of bytes submitted */
	char *wpend_buf;

	/* used during startup, digest all incoming/outgoing packets */
	EVP_MD_CTX finish_dgst1;
	EVP_MD_CTX finish_dgst2;

	/* this is set whenerver we see a change_cipher_spec message
	 * come in when we are not looking for one */
	int change_cipher_spec;

	int warn_alert;
	int fatal_alert;
	/* we alow one fatal and one warning alert to be outstanding,
	 * send close alert via the warning alert */
	int alert_dispatch;
	char send_alert[2];

	/* This flag is set when we should renegotiate ASAP, basically when
	 * there is no more data in the read or write buffers */
	int renegotiate;
	int total_renegotiations;
	int num_renegotiations;

	int in_read_app_data;

	struct	{
		/* Actually only needs to be 16+20 for SSLv3 and 12 for TLS */
		unsigned char finish_md[EVP_MAX_MD_SIZE*2];
		
		unsigned long message_size;
		int message_type;

		/* used to hold the new cipher we are going to use */
		SSL_CIPHER *new_cipher;
		DH *dh;

		/* used when SSL_ST_FLUSH_DATA is entered */
		int next_state;			

		int reuse_message;

		/* used for certificate requests */
		int cert_req;
		int ctype_num;
		char ctype[SSL3_CT_NUMBER];
		STACK *ca_names;

		int use_rsa_tmp;

		int key_block_length;
		unsigned char *key_block;

		EVP_CIPHER *new_sym_enc;
		EVP_MD *new_hash;
#ifdef HEADER_COMP_H
		SSL_COMP *new_compression;
#else
		char *new_compression;
#endif
		int cert_request;
		} tmp;

	} SSL3_CTX;

/* SSLv3 */
/*client */
/* extra state */
#define SSL3_ST_CW_FLUSH		(0x100|SSL_ST_CONNECT)
/* write to server */
#define SSL3_ST_CW_CLNT_HELLO_A		(0x110|SSL_ST_CONNECT)
#define SSL3_ST_CW_CLNT_HELLO_B		(0x111|SSL_ST_CONNECT)
/* read from server */
#define SSL3_ST_CR_SRVR_HELLO_A		(0x120|SSL_ST_CONNECT)
#define SSL3_ST_CR_SRVR_HELLO_B		(0x121|SSL_ST_CONNECT)
#define SSL3_ST_CR_CERT_A		(0x130|SSL_ST_CONNECT)
#define SSL3_ST_CR_CERT_B		(0x131|SSL_ST_CONNECT)
#define SSL3_ST_CR_KEY_EXCH_A		(0x140|SSL_ST_CONNECT)
#define SSL3_ST_CR_KEY_EXCH_B		(0x141|SSL_ST_CONNECT)
#define SSL3_ST_CR_CERT_REQ_A		(0x150|SSL_ST_CONNECT)
#define SSL3_ST_CR_CERT_REQ_B		(0x151|SSL_ST_CONNECT)
#define SSL3_ST_CR_SRVR_DONE_A		(0x160|SSL_ST_CONNECT)
#define SSL3_ST_CR_SRVR_DONE_B		(0x161|SSL_ST_CONNECT)
/* write to server */
#define SSL3_ST_CW_CERT_A		(0x170|SSL_ST_CONNECT)
#define SSL3_ST_CW_CERT_B		(0x171|SSL_ST_CONNECT)
#define SSL3_ST_CW_CERT_C		(0x172|SSL_ST_CONNECT)
#define SSL3_ST_CW_CERT_D		(0x173|SSL_ST_CONNECT)
#define SSL3_ST_CW_KEY_EXCH_A		(0x180|SSL_ST_CONNECT)
#define SSL3_ST_CW_KEY_EXCH_B		(0x181|SSL_ST_CONNECT)
#define SSL3_ST_CW_CERT_VRFY_A		(0x190|SSL_ST_CONNECT)
#define SSL3_ST_CW_CERT_VRFY_B		(0x191|SSL_ST_CONNECT)
#define SSL3_ST_CW_CHANGE_A		(0x1A0|SSL_ST_CONNECT)
#define SSL3_ST_CW_CHANGE_B		(0x1A1|SSL_ST_CONNECT)
#define SSL3_ST_CW_FINISHED_A		(0x1B0|SSL_ST_CONNECT)
#define SSL3_ST_CW_FINISHED_B		(0x1B1|SSL_ST_CONNECT)
/* read from server */
#define SSL3_ST_CR_CHANGE_A		(0x1C0|SSL_ST_CONNECT)
#define SSL3_ST_CR_CHANGE_B		(0x1C1|SSL_ST_CONNECT)
#define SSL3_ST_CR_FINISHED_A		(0x1D0|SSL_ST_CONNECT)
#define SSL3_ST_CR_FINISHED_B		(0x1D1|SSL_ST_CONNECT)

/* server */
/* extra state */
#define SSL3_ST_SW_FLUSH		(0x100|SSL_ST_ACCEPT)
/* read from client */
/* Do not change the number values, they do matter */
#define SSL3_ST_SR_CLNT_HELLO_A		(0x110|SSL_ST_ACCEPT)
#define SSL3_ST_SR_CLNT_HELLO_B		(0x111|SSL_ST_ACCEPT)
#define SSL3_ST_SR_CLNT_HELLO_C		(0x112|SSL_ST_ACCEPT)
/* write to client */
#define SSL3_ST_SW_HELLO_REQ_A		(0x120|SSL_ST_ACCEPT)
#define SSL3_ST_SW_HELLO_REQ_B		(0x121|SSL_ST_ACCEPT)
#define SSL3_ST_SW_HELLO_REQ_C		(0x122|SSL_ST_ACCEPT)
#define SSL3_ST_SW_SRVR_HELLO_A		(0x130|SSL_ST_ACCEPT)
#define SSL3_ST_SW_SRVR_HELLO_B		(0x131|SSL_ST_ACCEPT)
#define SSL3_ST_SW_CERT_A		(0x140|SSL_ST_ACCEPT)
#define SSL3_ST_SW_CERT_B		(0x141|SSL_ST_ACCEPT)
#define SSL3_ST_SW_KEY_EXCH_A		(0x150|SSL_ST_ACCEPT)
#define SSL3_ST_SW_KEY_EXCH_B		(0x151|SSL_ST_ACCEPT)
#define SSL3_ST_SW_CERT_REQ_A		(0x160|SSL_ST_ACCEPT)
#define SSL3_ST_SW_CERT_REQ_B		(0x161|SSL_ST_ACCEPT)
#define SSL3_ST_SW_SRVR_DONE_A		(0x170|SSL_ST_ACCEPT)
#define SSL3_ST_SW_SRVR_DONE_B		(0x171|SSL_ST_ACCEPT)
/* read from client */
#define SSL3_ST_SR_CERT_A		(0x180|SSL_ST_ACCEPT)
#define SSL3_ST_SR_CERT_B		(0x181|SSL_ST_ACCEPT)
#define SSL3_ST_SR_KEY_EXCH_A		(0x190|SSL_ST_ACCEPT)
#define SSL3_ST_SR_KEY_EXCH_B		(0x191|SSL_ST_ACCEPT)
#define SSL3_ST_SR_CERT_VRFY_A		(0x1A0|SSL_ST_ACCEPT)
#define SSL3_ST_SR_CERT_VRFY_B		(0x1A1|SSL_ST_ACCEPT)
#define SSL3_ST_SR_CHANGE_A		(0x1B0|SSL_ST_ACCEPT)
#define SSL3_ST_SR_CHANGE_B		(0x1B1|SSL_ST_ACCEPT)
#define SSL3_ST_SR_FINISHED_A		(0x1C0|SSL_ST_ACCEPT)
#define SSL3_ST_SR_FINISHED_B		(0x1C1|SSL_ST_ACCEPT)
/* write to client */
#define SSL3_ST_SW_CHANGE_A		(0x1D0|SSL_ST_ACCEPT)
#define SSL3_ST_SW_CHANGE_B		(0x1D1|SSL_ST_ACCEPT)
#define SSL3_ST_SW_FINISHED_A		(0x1E0|SSL_ST_ACCEPT)
#define SSL3_ST_SW_FINISHED_B		(0x1E1|SSL_ST_ACCEPT)

#define SSL3_MT_CLIENT_REQUEST			0
#define SSL3_MT_CLIENT_HELLO			1
#define SSL3_MT_SERVER_HELLO			2
#define SSL3_MT_CERTIFICATE			11
#define SSL3_MT_SERVER_KEY_EXCHANGE		12
#define SSL3_MT_CERTIFICATE_REQUEST		13
#define SSL3_MT_SERVER_DONE			14
#define SSL3_MT_CERTIFICATE_VERIFY		15
#define SSL3_MT_CLIENT_KEY_EXCHANGE		16
#define SSL3_MT_FINISHED			20

#define SSL3_MT_CCS				1

/* These are used when changing over to a new cipher */
#define SSL3_CC_READ		0x01
#define SSL3_CC_WRITE		0x02
#define SSL3_CC_CLIENT		0x10
#define SSL3_CC_SERVER		0x20
#define SSL3_CHANGE_CIPHER_CLIENT_WRITE	(SSL3_CC_CLIENT|SSL3_CC_WRITE)	
#define SSL3_CHANGE_CIPHER_SERVER_READ	(SSL3_CC_SERVER|SSL3_CC_READ)
#define SSL3_CHANGE_CIPHER_CLIENT_READ	(SSL3_CC_CLIENT|SSL3_CC_READ)
#define SSL3_CHANGE_CIPHER_SERVER_WRITE	(SSL3_CC_SERVER|SSL3_CC_WRITE)

#ifdef  __cplusplus
}
#endif
#endif

