// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//


#include "ezFCPlib.h"


extern char	*_fcpHost;
extern int	_fcpPort;
extern int	_fcpHtl;
extern int	_fcpRawMode;
extern int	_fcpRegress;

//
// Function:	fcpCreateHandle
//
// Arguments:	none
//
// Returns:		pointer to created handle, if successful
//				NULL if failed
// 

HFCP *fcpCreateHandle()
{
	HFCP *hfcp = malloc(sizeof(HFCP));

	hfcp->htl = _fcpHtl;
	hfcp->meta = NULL;
	hfcp->raw = _fcpRawMode;
	hfcp->openmode = 0;
	hfcp->regress = _fcpRegress;
	hfcp->keyindex.basedate[0] = '\0';

	// initialise write status block
	hfcp->wr_info.fd_data = -1;
	hfcp->wr_info.fd_meta = -1;
	hfcp->wr_info.num_data_wr = 0;
	hfcp->wr_info.num_meta_wr = 0;

	return hfcp;

}		// 'fcpCreateHandle()'


