// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//


#include "ezFCPlib.h"

extern char     _fcpID[];

#ifndef WINDOWS
#define _read(fd, buf, len) read(fd, buf, len)
#endif




//
// Function:	fcpPutKeyFromFile()
//
// Arguments:	hfcp
//
// Description:
//
//

fcpPutKeyFromFile(HFCP *hfcp, char *key, char *file, char *metadata)
{
	int meta_len;
	int fd;
	char buf[2048];
	int count;
	int filesize;
	int status;

	// can we open the file?
#ifdef WINDOWS
	if ((fd = _open(file, _O_BINARY)) < 0)
#else
        if ((fd = open(file, 0)) < 0)
#endif
		// failure - cannot open
		return -1;

	// how big's this file?
	filesize = _filelength(fd);

	// connect to Freenet FCP
	if (_fcpSockConnect(hfcp) != 0)
		return -1;

	// save the key
	if (_fcpParseUri(key, &hfcp->wr_info.uri) != 0)
	{
		_fcpSockDisconnect(hfcp);
		return -1;
	}

	//key = "KSK@xxxbug1";

	// create a put message
	if (metadata != NULL)
	{
		meta_len = strlen(metadata);
		sprintf(buf,
				"ClientPut\nURI=%s\nHopsToLive=%x\nDataLength=%x\nMetadataLength=%x\nData\n",
				key,
				hfcp->htl,
				filesize + meta_len,
				meta_len
				);
	}
	else
	{
		sprintf(buf,
				"ClientPut\nURI=%s\nHopsToLive=%x\nDataLength=%x\nData\n",
				key,
				hfcp->htl,
				filesize
				);
	}

	// send off client put command
#ifdef FCP_ID_REQUIRED
	_fcpSockSend(hfcp, _fcpID, 4);
#endif
	count = strlen(buf);
	if (_fcpSockSend(hfcp, buf, count) < count)
	{
		// send of put command failed
		_fcpSockDisconnect(hfcp);
		return -1;
	}

	// Send metadata if there's any
	if (metadata)
	{
		if (_fcpSockSend(hfcp, metadata, meta_len) < meta_len)
		{
			_fcpSockDisconnect(hfcp);
			return -1;
		}
	}

	// Now send data
	while ((count = _read(fd, buf, 2048)) > 0)
		_fcpSockSend(hfcp, buf, count);
	_close(fd);

	// expecting a success response
	status = _fcpRecvResponse(hfcp);

	switch (status)
	{
	case FCPRESP_TYPE_SUCCESS:
		_fcpLog("fcpPutKeyFromFile: SUCCESS: %s", file);
		break;
	case FCPRESP_TYPE_KEYCOLLISION:
		// either of these are ok
		_fcpLog("fcpPutKeyFromFile: KEYCOLLISON: %s", file);
		break;
	case FCPRESP_TYPE_FORMATERROR:
		_fcpLog("fcpPutKeyFromFile: FORMATERROR: %s", file);
		break;
	case FCPRESP_TYPE_URIERROR:
		_fcpLog("fcpPutKeyFromFile: URIERROR: %s", file);
		break;
	case FCPRESP_TYPE_ROUTENOTFOUND:
		_fcpLog("fcpPutKeyFromFile: ROUTENOTFOUND: %s", file);
		break;
	case FCPRESP_TYPE_SIZEERROR:
		_fcpLog("fcpPutKeyFromFile: SIZEERROR: %s", file);
		break;
	case FCPRESP_TYPE_FAILED:
		_fcpLog("fcpPutKeyFromFile: FAILED: %s", file);
		break;
	}

	// finished with connection
	_fcpSockDisconnect(hfcp);

	if (status != FCPRESP_TYPE_SUCCESS && status != FCPRESP_TYPE_KEYCOLLISION)
		return -1;

	// seems successful
	if (hfcp->conn.response.body.keypair.pubkey != NULL)
		strcpy(hfcp->pubkey, hfcp->conn.response.body.keypair.pubkey);
	if (hfcp->conn.response.body.keypair.privkey != NULL)
		strcpy(hfcp->privkey, hfcp->conn.response.body.keypair.privkey);
	if (hfcp->conn.response.body.keypair.uristr != NULL)
		strcpy(hfcp->created_uri, hfcp->conn.response.body.keypair.uristr);

	return 0;

}		// 'fcpPutKeyFromFile()'

