// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//


#include "ezFCPlib.h"



//
// Imported Declarations
//


extern char *_fcpHost;
extern int	_fcpPort;
extern int	_fcpHtl;
extern int	_fcpRawMode;
extern char *_fcpProgPath;
extern int	_fcpFileNum;	// temporary file count
extern char     _fcpID[];
extern int	_fcpRegress;



//
// Function:	fcpStartup()
//
// Arguments:	host		string containing hostname. NULL arg uses default of "127.0.0.1"
//				port		port number to communicate with FCP on. <= 0 defaults to Freenet standard 8082
//				defaultHtl	default hops to live. if 0, gets set to EZFCP_HTL_DEFAULT
//				raw			set to disable automatic metadata handling
//
// Returns:		0 if successful
//				-1 if failed
//

int fcpStartup(char *host, int port, int defaultHtl, int raw)
{
	char *exename;
	HFCP *hfcp;
	char *handshake = "ClientHello\nEndMessage\n";
	int  n;
	int  len;

	// set global parms
	_fcpHost = (host != NULL) ? strdup(host) : EZFCP_DEFAULT_HOST;
	_fcpPort = (port > 0) ? port : EZFCP_DEFAULT_PORT;
	_fcpHtl = (defaultHtl > 0) ? defaultHtl : EZFCP_DEFAULT_HTL;
	_fcpRawMode = (raw > 0) ? 1 : 0;
	_fcpRegress = EZFCP_DEFAULT_REGRESS;

#ifdef WINDOWS
	// note pathname of executable program
	_fcpProgPath = strdup(_pgmptr);
	exename = strrchr(_fcpProgPath, '\\'); // point to slash between path and filename
	*exename++ = '\0'; // split the string and point to filename part
#else
	_fcpProgPath = "/tmp";
#endif

	// set starting temp file number
	_fcpFileNum = 0;

	if (_fcpSockInit() != 0)
		return -1;

	// Create temporary handle
	hfcp = fcpCreateHandle();

	//
	// try a handshake
	//

	if (_fcpSockConnect(hfcp) != 0)
		return -1;

	len = strlen(handshake);
#ifdef FCP_ID_REQUIRED
	_fcpSockSend(hfcp, _fcpID, 4);
#endif
	n = _fcpSockSend(hfcp, handshake, len);
	if (n < len)
	{
		_fcpSockDisconnect(hfcp);
		return -1;
	}

	if (_fcpRecvResponse(hfcp) != FCPRESP_TYPE_HELLO)
	{
		_fcpSockDisconnect(hfcp);
		return -1;
	}

	_fcpSockDisconnect(hfcp);
	return 0;

}		// 'fcpStartup()'

