// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//


#include "ezFCPlib.h"

#include "meta_parse.h"

meta_lex(int *lvalp, METADATA *meta)
{
	// tokens are:
	//	"Redirect" "End" "Mapfile" "default" "freenet" "MSK" "KSK" "CHK" "SSK" '@' '/' '=' '\n' ':' 
	//  "Content-Type" STRING "increment" "baseline"
	char *st;
	int i;

	char tokbuf[256];
	char *s2 = tokbuf;
	int	 was_sol = meta->is_sol;
	META_TOK *tok;
	int c;
	int tok_found = -1;

	// pretend CRs (0x0d) don't exist
	while (((c = *meta->rawptr++) == '\r' || c == ' ' || c == '\t') && (c != '\0'))
		;

#ifdef _DEBUG
	for (i = 0, st = meta->rawptr - 1; st[i] != '\0' && st[i] != '\n'; i++)
		tokbuf[i] = st[i];
	tokbuf[i] = '\0';
//	printf("lex: '%s'\n", tokbuf);
#endif

	// try for one of the special characters
	if (c == '\0')
		return 0;			// end of metadata
	else if (c == '@')
		return TOK_AT;		// '@'
	else if (c == '/')
		return TOK_SLASH;	// '/'
	else if (c == '+')
		return TOK_PLUS;
	else if (c == '=')
		return TOK_EQUALS;	// '='
	else if (c == ':')
		return TOK_COLON;	// ':'
	else if (c == '\n')						// newline
	{
		meta->is_sol = 1;
		return TOK_NEWLINE;
	}

	// skip back
	meta->rawptr--;

	// reset 'at start of line' flag
	if (was_sol)
		meta->is_sol = 0;

	// grab a delimited token
	while ((c = *meta->rawptr) != '\0')
	{
		// ignore CRs (0x0d)
		if (c == '\r')
		{
			meta->rawptr++;
			continue;
		}

		// halt at terminal characters
		if (c == '@' || c == '/' || c == '=' || c == ':' || c == '\n')
			break;
		else
		{
			// add to string
			meta->rawptr++;
			*s2++ = c;
		}
	}


	// terminate gathered string
	*s2 = '\0';

	// do we have a known keyword?
	if (!strcmp(tokbuf, "Redirect"))			tok_found = TOK_REDIRECT;
	else if (!strcmp(tokbuf, "End"))			tok_found = TOK_END;
	else if (!strcmp(tokbuf, "Mapfile"))		tok_found = TOK_MAPFILE;
	else if (!strcmp(tokbuf, "default"))		tok_found = TOK_DEFAULT;
	else if (!strcmp(tokbuf, "freenet"))		tok_found = TOK_FREENET;
	else if (!strcmp(tokbuf, "MSK"))			tok_found = TOK_MSK;
	else if (!strcmp(tokbuf, "SSK"))			tok_found = TOK_SSK;
	else if (!strcmp(tokbuf, "KSK"))			tok_found = TOK_KSK;
	else if (!strcmp(tokbuf, "CHK"))			tok_found = TOK_CHK;
	else if (!strcmp(tokbuf, "Content-Type"))	tok_found = TOK_CONTENTTYPE;
	else if (!strcmp(tokbuf, "increment"))		tok_found = TOK_INCREMENT;
	else if (!strcmp(tokbuf, "baseline"))		tok_found = TOK_BASELINE;
	else
	{
		// no - we got a string
		tok = malloc(sizeof(META_TOK));
		tok->type = TOK_STRING;
		tok->body.str = strdup(tokbuf);
#ifdef _DEBUG
//	printf("Got string '%s'\n", tokbuf);
#endif
		*lvalp = (int)tok;
		tok_found = TOK_STRING;
	}

	// most tokens are not legal unless at start of line
	// so test for exemptions
	if (!was_sol
		&& tok_found != TOK_FREENET
		&& tok_found == TOK_MSK
		&& tok_found == TOK_SSK
		&& tok_found == TOK_KSK
		&& tok_found == TOK_CHK
	)
		tok_found = TOK_STRING;

	return tok_found;
}


int meta_error()
{
	return 0;
}
