// fcpget.c - simple command line client that uses FCP
// CopyLeft () 2001 by David McNab


#include "ezFCPlib.h"

//
// IMPORTED DECLARATIONS
//



//
// PRIVATE DECLARATIONS
//

static int	parse_args(int argc, char *argv[]);
static void usage();
static void	usage_long();


char *progname;

char *keyname = NULL;
char *keyfile = NULL;
char show_meta = 0;
char *meta_file = NULL;
int htl = 25;
char *host = "127.0.0.1";
//int port = 7892;
int port = 8082;
char raw_mode = 0;


int main(int argc, char* argv[])
{
	HFCP *hfcp;
	char buf[1024];
	int count;
	int fd;

//	int d_argc = 3;
//	char *d_argv[] = { "xxx", "-htl25", "KSK@AARDVARK"};

//	argc = d_argc;
//	argv = d_argv;

	// go thru command line args
	progname = argv[0];
	if (parse_args(argc, argv) == -1)
		usage();

	// fire up FCP library
	if (fcpStartup(host, port, htl, raw_mode) != 0)
		return 1;

	// create an FCP handle
	hfcp = fcpCreateHandle();
	fcpSetHtl(hfcp, htl);

	// try to get the key open
	if (fcpOpenKey(hfcp, keyname, (_FCP_O_READ | (hfcp->raw ? _FCP_O_RAW : 0))) != 0)
		return -1;

	// snarf key's metadata
	if (show_meta)
	{
		if (hfcp->meta == NULL)
			printf("---NO-METADATA-FOUND---\n");
		else if (meta_file == NULL)
		{
			// dump metadata to stdout
			printf("---START-OF_METADATA---\n%s", hfcp->meta->raw);
			puts("---END-OF-METADATA-----");
		}
		else
		{
#ifdef WINDOWS
			// nuke metadata file if it exists
			_unlink(meta_file);
		
			// open a file to write the key to
			if ((fd = _open(meta_file, _O_CREAT | _O_RDWR | _O_BINARY, _S_IREAD | _S_IWRITE)) < 0)
#else
			// nuke metadata file if it exists
			unlink(meta_file);
		
			if ((fd = open(meta_file, O_CREAT | O_WRONLY, S_IREAD | S_IWRITE)) < 0)
#endif
			{
				printf("Cannot create file '%s'\n", meta_file);
				return -1;
			}

#ifdef WINDOWS
			_write(fd, hfcp->meta->raw, hfcp->meta->len);
			_close(fd);
#else
			write(fd, hfcp->meta->raw, hfcp->meta->len);
			close(fd);
#endif
		}

	}

	// output key data, if any
	if (hfcp->keysize > 0)
	{
		// nuke file if it exists
		if (keyfile != NULL)
		{
#ifdef WINDOWS
			_unlink(keyfile);
	
			// open a file to write the key to
			if ((fd = _open(keyfile, _O_CREAT | _O_RDWR | _O_BINARY, _S_IREAD | _S_IWRITE)) < 0)
			{
				printf("Cannot create file '%s'\n", keyfile);
				return -1;
			}
#else
			unlink(keyfile);
	
			// open a file to write the key to
			if ((fd = open(keyfile, O_CREAT| O_WRONLY, S_IREAD | S_IWRITE)) < 0)
			{
				printf("Cannot create file '%s'\n", keyfile);
				return -1;
			}
#endif
		}
		else
			fd = 1;

#ifdef WINDOWS
		// suck all of key's data into this file
		while ((count = fcpReadKey(hfcp, buf, 1024)) > 0)
			_write(fd, buf, count);

		if (keyfile != NULL)
			_close(fd);
#else
		// suck all of key's data into this file
		while ((count = fcpReadKey(hfcp, buf, 1024)) > 0)
			write(fd, buf, count);

		if (keyfile != NULL)
			close(fd);
#endif
	}

	// all done
	fcpCloseKey(hfcp);
	fcpDestroyHandle(hfcp);
	return 0;



}


static int parse_args(int argc, char *argv[])
{
	int i;

	if (argc < 2)
		return -1;

	for (i = 1; i < argc; i++)
	{
		if (!strcmp(argv[i], "-h"))
			usage_long();
		if (!strncmp(argv[i], "-fcp", 4))
		{
			if (argv[i][4] == '\0')
				return -1;
			port = atoi(&argv[i][4]);
		}
		else if (!strncmp(argv[i], "-htl", 4))
		{
			if (argv[i][4] == '\0')
				return -1;
			htl = atoi(&argv[i][4]);
		}
		else if (!strncmp(argv[i], "-m", 2))
		{
			show_meta = 1;
			if (argv[i][2] != '\0')
				meta_file = &argv[i][2];
		}
		else if (!strncmp(argv[i], "-host=", 6))
		{
			if (argv[i][6] != '\0')
			{
				host = &argv[i][6];
				printf("host='%s'\n", host);
			}
		}
		else if (!strcmp(argv[i], "-r"))
			raw_mode = 1;
		else
		{
			keyname = argv[i++];
			if (i < argc)
				keyfile = argv[i];
			return 0;
		}
	}

	return -1;
}



static void usage()
{
	printf("Usage: %s [options] key [file]\n", progname);
	printf("run with '-h' for help\n");
	exit(1);
}


static void usage_long()
{
	printf("Help for '%s' - command line request client using FCP\n", progname);
	printf("syntax is '%s [options] key [file]\n", progname);
	puts("Description of [options]:");
	puts("-h                 Display this help");
	puts("-fcp<portnum>      Chooses freenet node's FCP port (default 8082)");
	puts("-htl<hops_to_live> Sets the hops to live for request (default 25)");
	puts("-host=hostname     Sets the remote host to connect to (default 127.0.0.1");
//	puts("-v                 Verbose - give running commentary");
	puts("-m[mfile]          outputs metadata to stdout (or [mfile])");
	puts("-r                 Raw mode - do not handle metadata");
	puts("\nIf [file] is omitted, key's data will be printed to stdout");
	exit(0);
}

