// fcpget.c - simple command line client that uses FCP
// CopyLeft () 2001 by David McNab


#include "ezFCPlib.h"

//
// IMPORTED DECLARATIONS
//



//
// PRIVATE DECLARATIONS
//

static int	parse_args(int argc, char *argv[]);
static void usage();
static void	usage_long();


char *progname;

char *keyfrom = NULL;
char *keyto = NULL;
int htl = 50;
char *host = "127.0.0.1";
//int port = 7892;
int port = 8082;

char buf[1024];

int main(int argc, char* argv[])
{
	HFCP *hfcp;
	char buf[1024];
	int count;
	int fd;
	int error;

//	int d_argc = 3;
//	char *d_argv[] = { "xxx", "-htl25", "KSK@AARDVARK"};

//	argc = d_argc;
//	argv = d_argv;

	// go thru command line args
	progname = argv[0];
	if (parse_args(argc, argv) == -1)
		usage();

	// fire up FCP library
	if (fcpStartup(host, port, htl, 0) != 0)
	{
		printf("Failed: Can't find Freenet node at '%s', port %d\n",  host, port);
		return 1;
	}

	// create an FCP handle
	hfcp = fcpCreateHandle();
	fcpSetHtl(hfcp, htl);

	// Create a redirect string
	sprintf(buf, "Redirect\nEnd\n%s\n", keyto);
	printf("Creating key ;%s'...\n", keyfrom);
	printf("Which redirects to '%s'\n", keyto);
	printf("This may take a few minutes, please wait...");
	fflush(stdout);

	error = fcpPutKeyFromMem(hfcp, keyfrom, NULL, buf, 0) ;
	putchar('\n');
	if (error != 0)
		printf("Sorry - something went wrong - may not have worked\n");
	else
		printf("Redirect successfully creatd\n");

	fcpDestroyHandle(hfcp);
	return 0;

}


static int parse_args(int argc, char *argv[])
{
	int i;

	if (argc < 2)
		return -1;

	for (i = 1; i < argc; i++)
	{
		if (!strcmp(argv[i], "-h"))
			usage_long();
		if (!strncmp(argv[i], "-fcp", 4))
		{
			if (argv[i][4] == '\0')
				return -1;
			port = atoi(&argv[i][4]);
		}
		else if (!strncmp(argv[i], "-htl", 4))
		{
			if (argv[i][4] == '\0')
				return -1;
			htl = atoi(&argv[i][4]);
		}
		else if (!strncmp(argv[i], "-host=", 6))
		{
			if (argv[i][6] != '\0')
			{
				host = &argv[i][6];
				printf("host='%s'\n", host);
			}
		}
		else
		{
			keyfrom = argv[i++];
			keyto = argv[i++];
			return 0;
		}
	}

	return -1;
}



static void usage()
{
	printf("Usage: %s [options] key [file]\n", progname);
	printf("run with '-h' for help\n");
	exit(1);
}


static void usage_long()
{
	printf("Help for '%s' - command line redirector client using FCP\n", progname);
	printf("syntax is '%s [options] key_from key_to\n", progname);
	puts("Description of [options]:");
	puts("-h                 Display this help");
	puts("-fcp<portnum>      Chooses freenet node's FCP port (default 8082)");
	puts("-htl<hops_to_live> Sets the hops to live for insertion (default 50)");
	puts("-host=hostname     Sets the remote host to connect to (default 127.0.0.1");
//	puts("-v                 Verbose - give running commentary");
	puts("\nIf [file] is omitted, key's data will be printed to stdout");
	exit(0);
}

