// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

//
// FreeWeb.h
//
// Definitions shared between FreeWeb Agent and FreeWeb Publisher
//


#define SYNCTHREAD_IDLE			'I'
#define SYNCTHREAD_UPLOADING	'U'
#define SYNCTHREAD_SETPARMS		'P'


//#define FREEWEB_PUB_KEY		"uVt8kcyiisdnGlj9LC37vBt4G5wQAgE"
#define FREEWEB_PUB_KEY		"uDT8iApCWc33MlNClfiMlIRHZOkQAgE"
//#define FREEWEB_PRIV_KEY	"GefpOikm5RBmakmTbp9Y8FXV~2~ddOc"
#define FREEWEB_PRIV_KEY	"GgyIDK5iFet2GOn-mm7~AkRl2JHlfdzxr2e0"

#define FREEWEB_KEYSERVER	"freeweb0.1a-1"

// standard Hops To Live for key operations
#define FREEWEB_HTL			43
#define FREEWEB_HTL_STR		"43"

#define DOMAIN_REG_CHECK_HTL 1		// how deeply to check if domain is registered

#ifdef _WINDOWS
#define DIR_DELIM_CHAR '\\'
#else
#define DIR_DELIM_CHAR '/'
#endif



typedef struct
{
	int debug;
	int multi_threaded;
	int hideConsole;
	int use_remote_proxy;
	char *rem_proxy_host;
	int  rem_proxy_port;
	char *haddr;			// default binding to localhost
	int   hport;
	int	fproxy_port;
	int webblock;			// flag which causes ALL mainstream http requests to be blocked
	int webblockdefault;	// default setting of webblock at startup
	int allowlocalhost;		// high paranoia here - even localhost is blocked if this flag isn't set
}
FW_CONFIGS;

