// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// AddSiteDialog.cpp : implementation file
//

#include "stdafx.h"
#include "afxdlgs.h"
#include "fwpubgui.h"
#include "shlobj.h"
#include "GetFolder.h"
#include "constants.h"
#include "config.h"
#include "sitedir.h"
#include "AddSiteDialog.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CString strTmpPath;

extern CSiteDir *pSiteDir;
extern CConfig *pConfig;


/////////////////////////////////////////////////////////////////////////////
// AddSiteDialog dialog


AddSiteDialog::AddSiteDialog(CWnd* pParent /*=NULL*/)
	: CDialog(AddSiteDialog::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_ICON_BRIGHT);

	//{{AFX_DATA_INIT(AddSiteDialog)
	m_Add_Site_Dir = _T("");
	m_Add_Site_Domain = _T("");
	m_Add_Site_Desc = _T("");
	//}}AFX_DATA_INIT
}


void AddSiteDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AddSiteDialog)
	DDX_Text(pDX, IDC_ADD_SITE_DIR, m_Add_Site_Dir);
	DDX_Text(pDX, IDC_ADD_SITE_DOMAIN, m_Add_Site_Domain);
	DDX_Text(pDX, IDC_ADD_SITE_DESC, m_Add_Site_Desc);
	DDV_MaxChars(pDX, m_Add_Site_Desc, 127);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(AddSiteDialog, CDialog)
	//{{AFX_MSG_MAP(AddSiteDialog)
	ON_BN_CLICKED(IDC_BUT_BROWSE, OnButBrowse)
	ON_BN_CLICKED(IDC_BUT_ADD_HELP, OnButAddHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AddSiteDialog message handlers

void AddSiteDialog::OnButBrowse() 
{
	// TODO: Add your control notification handler code here
	BROWSEINFO browse;
	static char	buf[MAX_PATH];
	static CString sel_folder;

	browse.hwndOwner = 0;
    browse.pidlRoot = NULL;
    browse.pszDisplayName = buf;
    browse.lpszTitle = "Please select the folder where\n"
						"the FreeWeb site you want to\n"
						"publish is located";
    browse.ulFlags = BIF_RETURNONLYFSDIRS;
    browse.lpfn = NULL;
    browse.lParam = NULL;
    browse.iImage = NULL;
 
//	SHBrowseForFolder(&browse);
	UpdateData(TRUE);
	if (GetFolder::browse(&sel_folder, "Select FreeWeb site folder", 0,  NULL, m_Add_Site_Dir))
	{
		m_Add_Site_Dir = sel_folder;

		// update folder field
		UpdateData(FALSE);
	}
}


void AddSiteDialog::OnButAddHelp() 
{
	// TODO: Add your control notification handler code here
	MessageBox(
		"This window is used for publishing a site to FreeWeb.\n"
		"The first thing you have to do is prepare a site on\n"
		"your own disk.\n\n"
		"IMPORTANT NOTES:\n"
		"1. Your site MUST contain a file called 'index.html'.\n"
		"2. None of the files on your site, and none of the\n"
		"   folders within or above it, may contain spaces\n"
		"3. When you choose a domain name, you don't have to\n"
		"   put '.free' at the end. If your domain name doesn't\n"
		"   end in '.free', then '.free' will be added to the\n"
		"   end.\n"
		"4. If you put 'www.' at the start, then it will be\n"
		"   deleted. The 'www.' prefix is ignored in FreeWeb\n"
		"   so if you have a domain 'john.free', then others\n"
		"   will be able to browse it with 'http://john.free'\n"
		"   or 'http://www.john.free'.\n"
		"5. Take care before you add a site that the site is\n"
		"   in a reasonable state, with no broken links.\n"
		"   Because once you publish a site to FreeWeb, then\n"
		"   make changes, then you can only upload new versions\n"
		"   of that site once per day\n"
		,
		"FreeWeb Publisher - Help for 'Add Site'",
		MB_OK);
}

void AddSiteDialog::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void AddSiteDialog::OnOK() 
{
	Site *thissite;

	// Spit if no directory selected
	UpdateData(TRUE);
	if (m_Add_Site_Dir.GetLength() == 0)
	{
		MessageBox("You must select a folder containing your site's files",
					PROGNAME, MB_OK);
		return;
	}

	// Spit if directory not valid
	if (!pSiteDir->site_directory_valid(m_Add_Site_Dir.GetBuffer(128)))
	{
//		char buf[256];
//
//		sprintf(buf, "You cannot use folder '%s' for a website\n"
//					 "Site folders must contain an 'index.html' file\n",
//					 m_Add_Site_Dir.GetBuffer(128));
//		MessageBox(buf, PROGNAME, MB_OK | MB_SYSTEMMODAL);
		return;
	}

	// Spit if no domain selected
	if (m_Add_Site_Domain.GetLength() == 0)
	{
		MessageBox("You must choose a domain name for this site",
					PROGNAME,
					MB_OK | MB_SYSTEMMODAL);
		return;
	}

	// Spit if domain already exists
	for (thissite = pConfig->firstsite; thissite != NULL; thissite = thissite->next)
		if (!strcmp(m_Add_Site_Domain, thissite->domainname))
			break;
	if (thissite != NULL)
	{
		MessageBox("This domain already exists!",
					PROGNAME,
					MB_OK | MB_SYSTEMMODAL);
		return;
	}

	CDialog::OnOK();
}

BOOL AddSiteDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
