// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// FwProxyThread.cpp : implementation file


#include "stdafx.h"
#include "fwpubgui.h"
#include "FwProxyThread.h"
#include "freeweb.h"
#include "constants.h"
#include "config.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


////////////////////////////////////////////////////////////////////////////
// NOTES
//
// This is just a C++ wrapper for fwproxy.c
// which allows fwproxy to be implemented in straight C, and readily built
// on Linux and other platforms
////////////////////////////////////////////////////////////////////////////


//
// IMPORTED DECLARATIONS
//

extern CConfig		*pConfig;


extern "C" void fwproxy(int listenport,
						int extproxyenabled, char *extproxyaddr, int extproxyport,
						int comeback, int singlethread);
extern "C" void fwproxy_newport(int newport);
extern "C" void fwproxy_newextproxy(int enabled, char *addr, int port);
extern "C" void fwproxy_webblock(int onoff);
extern "C" void fwproxy_setdir(char *dir);
extern "C" void fwproxy_sethtl(int htl);


/////////////////////////////////////////////////////////////////////////////
// CFwProxyThread

IMPLEMENT_DYNCREATE(CFwProxyThread, CWinThread)

CFwProxyThread::CFwProxyThread()
{
}

CFwProxyThread::~CFwProxyThread()
{
}

BOOL CFwProxyThread::InitInstance()
{
	// tell fwproxy where to find the html files
	fwproxy_setdir(pConfig->exepath);

	// launch the proxy
	fwproxy(listenPort, extProxyEnabled, extProxyAddr, extProxyPort, 1, singleThread);

	// set the webblocking mode
	fwproxy_webblock(webBlock);
	return TRUE;
}

int CFwProxyThread::ExitInstance()
{
	// TODO:  perform any per-thread cleanup here
	return CWinThread::ExitInstance();
}

BEGIN_MESSAGE_MAP(CFwProxyThread, CWinThread)
	//{{AFX_MSG_MAP(CFwProxyThread)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFwProxyThread message handlers

void CFwProxyThread::SetNewPort(int port)
{
	listenPort = port;
	fwproxy_newport(port);
}

void CFwProxyThread::NewExtProxy(int enabled, char *host, int port)
{
	strcpy(extProxyAddr, host);
	extProxyPort = port;
	extProxyEnabled = enabled;
	fwproxy_newextproxy(enabled, host, port);
}

void CFwProxyThread::WebBlock(int mode)
{
	webBlock = mode;
	fwproxy_webblock(mode);
}

void CFwProxyThread::SetHtl(int htl)
{

}

void CFwProxyThread::Startup(int listenport, int extproxy_enabled, char *extproxyaddr, int extproxyport,
							 int singlethread, int webblock)
{
	// save args in private variables
	listenPort = listenport;
	extProxyEnabled = extproxy_enabled;
	strcpy(extProxyAddr, extproxyaddr);
	extProxyPort = extproxyport;
	singleThread = singlethread;
	webBlock = webblock;

	// launch the thread
	this->CreateThread(0,0);
}

