// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

/**/

//#include <windows.h>  // main Windows header
//#include <windowsx.h> // message cracker macros, etc.
//#include <shellapi.h> // Shell32 api

#include "stdafx.h"

#include "process.h"

#include "ezFCPlib.h"

#include "constants.h"
#include "sitelist.h"
#include "fwpubgui.h"
#include "fwpubguiDlg.h"
#include "addsite.h"
#include "config.h"
#include "log.h"
#include "util.h"
#include "sitedir.h"
#include "gethttp.h"
#include "dropdlg.h"
#include "syncsite.h"
#include "configdlg.h"
#include "siteprop.h"
#include "freeweb.h"
#include "splash.h"

//#include "syncqueue.h"

#include "tray.h"
//#include "../fwagent.h"
//#include "../freeweb.h"

#include "resource.h"


/////////////////////////////////////////////////////////////////////////////
// Instance pointers to classes

extern CFwpubguiDlg		*pDlg;
extern CLog				*pLog;
extern CUtil			*pUtil;
extern CConfig			*pConfig;
extern CAddSite			*pAdd;
extern CSiteDir			*pSiteDir;
extern CGetHttp			*pHttp;
extern CDropDlg			*pDropDlg;
extern CSiteList		*pSiteList;
extern CSyncSite		*pSyncSite;
extern CConfigDlg		*pConfigDlg;
extern CSiteProp		*pSiteProp;


#define UWM_SYSTRAY (WM_USER + 1) // Sent to us by the systray
#define NUM_TOOLTIPS 10           // Number of ToolTips in our table


extern int			keep_running;
//extern FW_CONFIGS	fwconfigs;		/* port we're listening on */

//int about_dialog();

void __cdecl tray_thread(void *);
//int WINAPI tray_thread(HINSTANCE hInstance);


LRESULT CALLBACK wndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

HINSTANCE ghInst;
static char *progpath;

int WINAPI tray(HINSTANCE hInstance)
{
	////unsigned long thread_addr;

	progpath = pConfig->exepath;
	_beginthread(tray_thread, 0, hInstance);
	return 0;
}


//int WINAPI tray_thread(HINSTANCE hInstance)
void __cdecl tray_thread(void *arg)
{
	HINSTANCE hInstance = (HINSTANCE)arg;
	HWND hwnd;
	WNDCLASSEX wc;
	MSG msg;
	NOTIFYICONDATA nid;
	char *classname = "FreeWebAgent.NOTIFYICONDATA.hWnd";
	////int i;

  ghInst = hInstance;

  // Low priority -- don't soak up as many CPU cycles.
  // This won't make a difference unless we are doing background processing
  // in this process.
  SetPriorityClass(GetCurrentProcess(), IDLE_PRIORITY_CLASS);

  /* Create a window class for the window that receives systray notifications.
     The window will never be displayed, although there's no reason it couldn't
     be (it just wouldn't be very useful in this program, and in most others).
  */
  wc.cbSize = sizeof(WNDCLASSEX);
  wc.style = 0;
  wc.lpfnWndProc = wndProc;
  wc.cbClsExtra = wc.cbWndExtra = 0;
  wc.hInstance = hInstance;
  wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_FREEWEB));
  wc.hCursor = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
  wc.lpszMenuName = NULL;
  wc.lpszClassName = classname;
  wc.hIconSm = (struct HICON__ *)LoadImage(hInstance, MAKEINTRESOURCE(IDI_FREEWEB), IMAGE_ICON,
                        GetSystemMetrics(SM_CXSMICON),
                        GetSystemMetrics(SM_CYSMICON),
						0);

  RegisterClassEx(&wc);

  // Create window. Note that WS_VISIBLE is not used, and window is never shown
  hwnd = CreateWindowEx(0, classname, classname, WS_POPUP, CW_USEDEFAULT, 0,
          CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

  // Fill out NOTIFYICONDATA structure
  nid.cbSize = sizeof(NOTIFYICONDATA); // size
  nid.hWnd = hwnd; // window to receive notifications
  nid.uID = 1;     // application-defined ID for icon (can be any UINT value)
  nid.uFlags = NIF_MESSAGE |  // nid.uCallbackMessage is valid, use it
                NIF_ICON |     // nid.hIcon is valid, use it
                NIF_TIP;       // nid.szTip is valid, use it
  nid.uCallbackMessage = UWM_SYSTRAY; // message sent to nid.hWnd
  nid.hIcon = (struct HICON__ *)LoadImage(hInstance, MAKEINTRESOURCE(IDI_FREEWEB), IMAGE_ICON,
                        GetSystemMetrics(SM_CXSMICON),
                        GetSystemMetrics(SM_CYSMICON), 0); // 16x16 icon
  // szTip is the ToolTip text (64 byte array including NULL)
  sprintf(nid.szTip, "FreeWeb Agent listening on port %d", 666); //fwconfigs.hport);

  // NIM_ADD: Add icon; NIM_DELETE: Remove icon; NIM_MODIFY: modify icon
  Shell_NotifyIcon(NIM_ADD, &nid); // This adds the icon

  while (GetMessage(&msg, NULL, 0, 0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

  return;
// return msg.wParam;
}


LRESULT CALLBACK wndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  POINT pt;
  HMENU hmenu, hpopup;
  NOTIFYICONDATA nid;

  char filebuf[256];

  switch (message) {
    case WM_CREATE:
      SetTimer(hwnd, 0x29a, 2000, NULL); // 2-second timer
      return TRUE;

    case WM_TIMER:
      // Every 2 seconds, we will change something -- in this case, the ToolTip
	  sprintf(nid.szTip, "FreeWeb Agent is listening on port %d",
				pConfig->listenPort); //fwconfigs.hport);
      //strcpy(nid.szTip, "FreeWeb Agent");
      nid.cbSize = sizeof(NOTIFYICONDATA);
      nid.hWnd = hwnd;
      nid.uID = 1;
      nid.uFlags = NIF_TIP; // Only nid.szTip and nid.uID are valid, change tip
      Shell_NotifyIcon(NIM_MODIFY, &nid); // Modify tooltip
      return TRUE;

    case WM_DESTROY:
      nid.cbSize = sizeof(NOTIFYICONDATA);
      nid.hWnd = hwnd;
      nid.uID = 1;
      nid.uFlags = NIF_TIP; // not really sure what to put here, but it works
      Shell_NotifyIcon(NIM_DELETE, &nid); // This removes the icon
      PostQuitMessage(0);
      KillTimer(hwnd, 0x29a);
      return TRUE;

    case UWM_SYSTRAY: // We are being notified of mouse activity over the icon
      switch (lParam) {
        case WM_RBUTTONUP: // Let's track a popup menu
          GetCursorPos(&pt);
          hmenu = LoadMenu(ghInst, MAKEINTRESOURCE(IDM_CONTEXTMAIN));
          hpopup = GetSubMenu(hmenu, 0);

          /* SetForegroundWindow and the ensuing null PostMessage is a
             workaround for a Windows 95 bug (see MSKB article Q135788,
             http://www.microsoft.com/kb/articles/q135/7/88.htm, I think).
             In typical Microsoft style this bug is listed as "by design".
             SetForegroundWindow also causes our MessageBox to pop up in front
             of any other application's windows. */
          SetForegroundWindow(hwnd);
          /* We specifiy TPM_RETURNCMD, so TrackPopupMenu returns the menu
             selection instead of returning immediately and our getting a
             WM_COMMAND with the selection. You don't have to do it this way.
          */
          switch (TrackPopupMenu(hpopup,            // Popup menu to track
                                 TPM_RETURNCMD |    // Return menu code
                                   TPM_RIGHTBUTTON, // Track right mouse button?
                                 pt.x, pt.y,        // screen coordinates
                                 0,                 // reserved
                                 hwnd,              // owner
                                 NULL))             // LPRECT user can click in
                                                    // without dismissing menu
          {
            case IDM_EXIT:
				/* signal main thread to shut down */
				//keep_running = 0;
				DestroyWindow(hwnd);
				pConfig->save();
				ExitProcess(0);
				break;

			case IDM_HELP:
				sprintf(filebuf, "%s\\%s", progpath, "freeweb.hlp");
				ShellExecute(  0, "Open", filebuf, NULL, NULL, SW_SHOW);
				break;

			case IDM_SHOWWINDOW:
			if (pDlg->isShowing)
			{
				pDlg->ShowWindow(SW_RESTORE);
				pDlg->SetForegroundWindow();
			}
			else
				pDlg->DoModal();
//				pDlg->ShowWindow(SW_RESTORE);
				//cfunc_showMainDlg();
				//sprintf(filebuf, "%s\\%s", progpath, "launch.exe");
				//ShellExecute(  0, "Open", filebuf, "publish", progpath, SW_SHOW);
				break;

              break;
          }
          PostMessage(hwnd, 0, 0, 0); // see above
          DestroyMenu(hmenu); // Delete loaded menu and reclaim its resources
          break;

        case WM_LBUTTONDBLCLK:
			if (pDlg->isShowing)
			{
				pDlg->ShowWindow(SW_RESTORE);
				pDlg->SetForegroundWindow();
			}
			else
				pDlg->DoModal();
			break;
        // Other mouse messages: WM_MOUSEMOVE, WM_MBUTTONDOWN, etc.
      }
      return TRUE; // I don't think that it matters what you return.
  }
  return DefWindowProc(hwnd, message, wParam, lParam);
}
