// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// ConfigDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"

#include "ConfigDlg.h"
#include "constants.h"
#include "config.h"
#include "sitelist.h"
#include "fwpubgui.h"
#include "fwpubguiDlg.h"
#include "util.h"
#include "log.h"
#include "sitedir.h"
#include "addsite.h"
#include "dropdlg.h"
#include "configdlg.h"

#include "addsitedialog.h"
#include "syncsite.h"

#include "freeweb.h"
#include "splash.h"

#include "FwProxyThread.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// pointers to global class instances

extern CLog				*pLog;
extern CUtil			*pUtil;
extern CConfig			*pConfig;
extern CSiteDir			*pSiteDir;
extern CAddSite			*pAdd;
extern CDropDlg			*pDropDlg;
extern CSiteList		*pSiteList;
extern CSyncSite		*pSyncSite;
//extern CAboutDlg	*pAboutDlg;
extern CConfigDlg		*pConfigDlg;
extern CFwProxyThread	*pProxy;



/////////////////////////////////////////////////////////////////////////////
// CConfigDlg dialog


CConfigDlg::CConfigDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_ICON_BRIGHT);

	//{{AFX_DATA_INIT(CConfigDlg)
	m_NodeAddr = _T("");
	m_htl = 0;
	m_fcpPort = 0;
	m_BrowserProxyPort = 0;
	m_htlReq = 0;
	m_DaysRegress = 0;
	m_ExtProxyAddr = _T("");
	m_ExtProxyEnabled = FALSE;
	m_ExtProxyPort = 0;
	m_WebBlock = FALSE;
	m_WebBlockStartup = FALSE;
	m_TrustKsks = FALSE;
	m_MaxInsertThreads = 0;
	//}}AFX_DATA_INIT
}


void CConfigDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigDlg)
	DDX_Text(pDX, IDC_CONFIG_NODEADDR, m_NodeAddr);
	DDV_MaxChars(pDX, m_NodeAddr, 80);
	DDX_Text(pDX, IDC_CONFIG_HTL, m_htl);
	DDV_MinMaxUInt(pDX, m_htl, 10, 50);
	DDX_Text(pDX, IDC_CONFIG_NODEPORT, m_fcpPort);
	DDV_MinMaxUInt(pDX, m_fcpPort, 1, 65535);
	DDX_Text(pDX, IDC_BROWSER_PROXY_PORT, m_BrowserProxyPort);
	DDV_MinMaxInt(pDX, m_BrowserProxyPort, 1, 65535);
	DDX_Text(pDX, IDC_CONFIG_HTL_REQ, m_htlReq);
	DDV_MinMaxInt(pDX, m_htlReq, 1, 100);
	DDX_Text(pDX, IDC_DAYS_REGRESS, m_DaysRegress);
	DDV_MinMaxUInt(pDX, m_DaysRegress, 0, 31);
	DDX_Text(pDX, IDC_EXT_PROXY_ADDR, m_ExtProxyAddr);
	DDV_MaxChars(pDX, m_ExtProxyAddr, 127);
	DDX_Check(pDX, IDC_EXT_PROXY_ENABLED, m_ExtProxyEnabled);
	DDX_Text(pDX, IDC_EXT_PROXY_PORT, m_ExtProxyPort);
	DDV_MinMaxUInt(pDX, m_ExtProxyPort, 1, 65535);
	DDX_Check(pDX, IDC_WEB_BLOCK, m_WebBlock);
	DDX_Check(pDX, IDC_WEB_BLOCK_STARTUP, m_WebBlockStartup);
	DDX_Check(pDX, IDC_TRUST_KSKS, m_TrustKsks);
	DDX_Text(pDX, IDC_MAX_INSERT_THREADS, m_MaxInsertThreads);
	DDV_MinMaxUInt(pDX, m_MaxInsertThreads, 1, 16);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigDlg, CDialog)
	//{{AFX_MSG_MAP(CConfigDlg)
	ON_BN_CLICKED(IDC_CONFIG_BUT_HELP, OnConfigButHelp)
	ON_NOTIFY(NM_OUTOFMEMORY, IDC_SPIN_MAX_THREADS, OnSpinMaxThreads)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigDlg message handlers

BOOL CConfigDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConfigDlg::OnConfigButHelp() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
	char buf[256];
	sprintf(buf, "%s\\%s", pConfig->progpath, "freeweb.hlp");
	ShellExecute(  0, "Open", buf, NULL, NULL, SW_SHOW);
	
}

int CConfigDlg::DoDlg()
{
	////int ret;

	// initialise dialog fields
	m_NodeAddr = pConfig->serverAddress;
	m_fcpPort = pConfig->fcpPort;
	m_htl = pConfig->htl;
	m_htlReq = pConfig->htlReq;
	m_BrowserProxyPort = pConfig->listenPort;
	m_DaysRegress = pConfig->daysRegress;
	m_ExtProxyAddr = pConfig->extProxyAddr;
	m_ExtProxyPort = pConfig->extProxyPort;
	m_ExtProxyEnabled = pConfig->extProxyEnabled;
	m_htlReq = pConfig->htlReq;
	m_WebBlock = pConfig->blockWebAccess;
	m_WebBlockStartup = pConfig->blockWebAtStartup;
	m_TrustKsks = pConfig->trustKsks;
	m_MaxInsertThreads = pConfig->maxInsertThreads;

	if (DoModal() == IDOK)
	{
		// retrieve dialog fields
		strcpy(pConfig->serverAddress, m_NodeAddr);
		pConfig->fcpPort = m_fcpPort;
		pConfig->htl = m_htl;
		pConfig->htlReq = m_htlReq;

		pConfig->listenPort = m_BrowserProxyPort;
		pConfig->daysRegress = m_DaysRegress;
		strcpy(pConfig->extProxyAddr, m_ExtProxyAddr);
		pConfig->extProxyPort = m_ExtProxyPort;
		pConfig->extProxyEnabled = m_ExtProxyEnabled;
		pConfig->htlReq = m_htlReq;
		pConfig->blockWebAccess = m_WebBlock;
		pConfig->blockWebAtStartup = m_WebBlockStartup;
		pConfig->trustKsks = m_TrustKsks;
		pConfig->maxInsertThreads = m_MaxInsertThreads;

		pConfig->save();
		pProxy->SetNewPort(m_BrowserProxyPort);
		pProxy->NewExtProxy(m_ExtProxyEnabled, m_ExtProxyAddr.GetBuffer(1), m_ExtProxyPort);
		pProxy->WebBlock(m_WebBlock);
		pProxy->SetHtl(pConfig->htlReq);
	}
	return 0;
}

void CConfigDlg::OnSpinMaxThreads(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}
