// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

#if !defined(AFX_FWPROXYTHREAD_H__37268302_97A7_4A68_B4D0_4A5B57D5EB25__INCLUDED_)
#define AFX_FWPROXYTHREAD_H__37268302_97A7_4A68_B4D0_4A5B57D5EB25__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// FwProxyThread.h : header file
//



/////////////////////////////////////////////////////////////////////////////
// CFwProxyThread thread

class CFwProxyThread : public CWinThread
{
	DECLARE_DYNCREATE(CFwProxyThread)
public:
	CFwProxyThread();           // protected constructor used by dynamic creation
	virtual ~CFwProxyThread();

// Attributes
public:

// Operations
public:
	void Startup(int listenport,
				 int extproxyenabled, char *extproxyaddr, int extproxyport,
				 int singlethread, int webblock);
	void WebBlock(int mode);
	void NewExtProxy(int enabled, char *host, int port);
	void SetNewPort(int port);
	void SetHtl(int htl);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFwProxyThread)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation
protected:
	int extProxyEnabled;
	int webBlock;
	int singleThread;
	int extProxyPort;
	char extProxyAddr[128];
	int listenPort;

	// Generated message map functions
	//{{AFX_MSG(CFwProxyThread)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FWPROXYTHREAD_H__37268302_97A7_4A68_B4D0_4A5B57D5EB25__INCLUDED_)
