// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// SiteProp.cpp : implementation file
//

#include "stdafx.h"
#include "fwpubgui.h"
#include "constants.h"
#include "config.h"
#include "SiteProp.h"
#include "log.h"
#include "sitedir.h"
#include "GetFolder.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CConfig	*pConfig;
extern CLog		*pLog;
extern CSiteDir *pSiteDir;


/////////////////////////////////////////////////////////////////////////////
// CSiteProp dialog


CSiteProp::CSiteProp(CWnd* pParent /*=NULL*/)
	: CDialog(CSiteProp::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_ICON_BRIGHT);

	//{{AFX_DATA_INIT(CSiteProp)
	m_dateCreated = _T("");
	m_dateUpdated = _T("");
	m_desc = _T("");
	m_domain = _T("");
	m_folder = _T("");
	m_freenetURL = _T("");
	m_sskPriv = _T("");
	m_sskPub = _T("");
	m_status = _T("");
	m_GenIndex = FALSE;
	m_freenetURLinsecure = _T("");
	//}}AFX_DATA_INIT
}


void CSiteProp::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSiteProp)
	DDX_Text(pDX, IDC_SITEPROP_DATE_CREATED, m_dateCreated);
	DDX_Text(pDX, IDC_SITEPROP_DATE_UPDATED, m_dateUpdated);
	DDX_Text(pDX, IDC_SITEPROP_DESC, m_desc);
	DDX_Text(pDX, IDC_SITEPROP_DOMAIN, m_domain);
	DDX_Text(pDX, IDC_SITEPROP_FOLDER, m_folder);
	DDX_Text(pDX, IDC_SITEPROP_FREENET_URL, m_freenetURL);
	DDX_Text(pDX, IDC_SITEPROP_SSK_PRIV, m_sskPriv);
	DDX_Text(pDX, IDC_SITEPROP_SSK_PUB, m_sskPub);
	DDX_Text(pDX, IDC_SITEPROP_STATUS, m_status);
	DDX_Check(pDX, IDC_SITEPROP_GENINDEX, m_GenIndex);
	DDX_Text(pDX, IDC_SITEPROP_FREENET_URL_INSECURE, m_freenetURLinsecure);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSiteProp, CDialog)
	//{{AFX_MSG_MAP(CSiteProp)
	ON_BN_CLICKED(IDC_BUT_SITEPROP_BROWSE, OnButSitepropBrowse)
	ON_BN_CLICKED(IDC_SITEPROP_HELP, OnSitepropHelp)
	ON_BN_CLICKED(IDC_BUT_COPY_SECURE, OnButCopySecure)
	ON_BN_CLICKED(IDC_BUT_COPY_INSECURE, OnButCopyInsecure)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSiteProp message handlers

void CSiteProp::edit(char *domain)
{
	char thisdom[128];
	char freenetURL[128];
	char freenetURLinsecure[128];
	char *s;

	strcpy(thisdom, domain);
	if ((s = strrchr(thisdom, '.')) == NULL)
		return;

	if (strcmp(s, ".free") != 0)
		return;

	*s = '\0';

	// locate domain in sites chain
	for (selectedSite = pConfig->firstsite; selectedSite != NULL; selectedSite = selectedSite->next)
		if (!strcmp(selectedSite->domainname, thisdom))
			break;

	if (selectedSite == NULL)
	{
		pLog->Write(LOG_CRITICAL, LOG_CRITICAL,
					"Panic = can't rememver domain '%s'", (int)domain);
		pLog->Write(LOG_CRITICAL, LOG_CRITICAL, "Please report this as a bug");
		return;
	}

	// ok - got the domain
	m_dateCreated = selectedSite->datecreated;
	m_dateUpdated = selectedSite->dateupdated;
	m_desc = selectedSite->description;
	m_domain = domain;
	m_folder = selectedSite->rootdir;

	// get site's SSK key if available
	if (strlen(selectedSite->ssk_pub) > 0)
	{
		sprintf(freenetURL, "freenet:MSK@SSK@%s/%s//", selectedSite->ssk_pub, thisdom);
		sprintf(freenetURLinsecure, "freenet:MSK@KSK@freeweb/%s//", thisdom);
	}
	else
	{
		strcpy(freenetURL, "Not available - site not published yet");
		strcpy(freenetURLinsecure, "Not available - site not published yet");
	}

	m_freenetURL = freenetURL;
	m_freenetURLinsecure = freenetURLinsecure;
	m_sskPriv = selectedSite->ssk_priv;
	m_sskPub = selectedSite->ssk_pub;
	m_GenIndex = selectedSite->generatedIndex;

	m_status = "<not used in v0.1.2 alpha version>";

	this->DoModal();

	selectedSite->generatedIndex = m_GenIndex;
}

void CSiteProp::OnOK() 
{
	char buf[256];
	char *folder;

	// TODO: Add extra validation here
	UpdateData(TRUE);
	folder = m_folder.GetBuffer(1);

	if (strcmp(selectedSite->rootdir, folder) != 0)
	{
		// check that this is a valid directory
		if (!pSiteDir->site_directory_valid(folder))
		{
			// no good
			sprintf(buf, "'%s' is not a valid site directory", folder);
			MessageBox(buf, "FreeWeb - Invalid Site Directory", MB_SYSTEMMODAL);
			return;
		}

		// confirm with user
		sprintf(buf,
				"Do you really want to abandon the files in\n"
				"'%s'\n"
				"and base this site on the files in:\n"
				"'%s'?"
				,
				selectedSite->rootdir,
				folder);

		if (MessageBox(buf, "FreeWeb - confirm new folder location", MB_SYSTEMMODAL | MB_YESNO) == IDNO)
			// user says no
			return;

		// user says yes
		strcpy(selectedSite->rootdir, folder);
		pConfig->save();

	}
	
	CDialog::OnOK();
}

void CSiteProp::OnButSitepropBrowse() 
{
	// TODO: Add your control notification handler code here
	BROWSEINFO browse;
	static char	buf[MAX_PATH];
	static CString sel_folder;

	browse.hwndOwner = 0;
    browse.pidlRoot = NULL;
    browse.pszDisplayName = buf;
    browse.lpszTitle = "Please select the new folder where\n"
						"your site's files are to be based";
    browse.ulFlags = BIF_RETURNONLYFSDIRS;
    browse.lpfn = NULL;
    browse.lParam = NULL;
    browse.iImage = NULL;
 
//	SHBrowseForFolder(&browse);
	UpdateData(TRUE);
	if (GetFolder::browse(&sel_folder, "Select FreeWeb site folder", 0,  NULL, m_folder))
	{
		m_folder = sel_folder;

		// update folder field
		UpdateData(FALSE);
	}
	
}

BOOL CSiteProp::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSiteProp::OnHelp() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
	char buf[256];
	sprintf(buf, "%s\\%s", pConfig->progpath, "freeweb.hlp");
	ShellExecute(  0, "Open", buf, NULL, NULL, SW_SHOW);
	
}

void CSiteProp::OnSitepropHelp() 
{
	// TODO: Add your control notification handler code here
	char buf[256];
	sprintf(buf, "%s\\%s", pConfig->progpath, "freeweb.hlp");
	ShellExecute(  0, "Open", buf, NULL, NULL, SW_SHOW);
	
}

void CSiteProp::OnButCopySecure() 
{
	// TODO: Add your control notification handler code here
	
}

void CSiteProp::OnButCopyInsecure() 
{
	// TODO: Add your control notification handler code here
	if (!OpenClipboard())
		MessageBox("fucked", "FreeWeb hassles", MB_SYSTEMMODAL);

}
