// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// addsite.cpp: implementation of the CAddSite class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "stdafx.h"

#include "freeweb.h"

#include "constants.h"
#include "sitelist.h"
#include "fwpubgui.h"
#include "fwpubguidlg.h"
#include "addsite.h"
#include "util.h"
#include "log.h"
#include "config.h"
#include "sitedir.h"
#include "gethttp.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAddSite::CAddSite()
{

}

CAddSite::~CAddSite()
{

}


extern CFwpubguiDlg	*pDlg;
extern CLog			*pLog;
extern CUtil		*pUtil;
extern CConfig		*pConfig;
extern CAddSite		*pAdd;
extern CSiteDir		*pSiteDir;
extern CGetHttp		*pHttp;




/*
 * fpublish_add()
 *
 * Publishes a site to Freenet freeweb
 *
 * Arguments:
 *
 *		domain		full domain name
 *
 *		dir			full pathname of directory to publish
 *
 * Returns:
 *
 *		0 if successful
 *		nonzero if failed
 *
 * Notes: If site creation succeeds, then the following is done:
 *	1) A 'Site' structure is created for the new site
 *	2) Entire all-sites-map is re-written to disk
 */

CAddSite::add(char *user_domain, char *dir, char *description)
{
//	char	base_domain[64];		// root-level domain name
	char	*s;
	int		domain_len = strlen(user_domain);
	int		i;
	Site	*thissite;
	char	dns_key[128];
	char	*domain = strdup(user_domain);
	////char	*page;
	char	buf[256];

	// spit if no domain given
	if (user_domain == NULL || !*user_domain)
		return 1;

	/* spit if domain name too long */
	if (strlen(user_domain) > DOMAINNAMEMAXLEN)
	{
		pLog->Write(LOG_CRITICAL, LOG_CRITICAL,
					"Bad domain '%s'\n\nDomain names must not be be longer than %d chars",
					(int)user_domain, DOMAINNAMEMAXLEN);
		return 1;
	}

	/* spit if any chars are not alphanum or '.' or '-' or '_', or if last char is '.' */
	for (s = user_domain; i = *s; s++)
		if (!iswalnum((wint_t)i) && (i != '.') && (i != '-') && (i != '_'))
			break;
	if (i != '\0')
	{
		pLog->Write(LOG_CRITICAL, LOG_CRITICAL,
					"Bad domain name '%s'\n\nContains invalid characters\n",
					(int)user_domain);
		printf("Domain names must be made up of letters and/or numbers\n");
		return 1;
	}
	if (*(s - 1) == '.')
	{
		pLog->Write(LOG_CRITICAL, LOG_CRITICAL,
					"Bad domain '%s'\n\nLast character of domain cannot be '.'\n",
					(int)user_domain);
		return 1;
	}

	/* spit if directory is invalid */
	if (!pSiteDir->site_directory_valid(dir))
	{
		pLog->Write(LOG_CRITICAL, LOG_CRITICAL,
					 "Invalid site directory '%s'",
					 (int)dir);
		return 1;
	}

	/* strip any leading 'www' */
	if (!strncmp(domain, "www.", 4))
		domain += 4;

	/* delete ".free" at end */
	if ((s = strstr(domain, ".free")) == domain + domain_len - 5)
		*s = '\0';

	/* now extract root level domain */
	s = strrchr(domain, '.');
	if (s == NULL)
		s = domain;
	else
		s++;

#ifdef OLD_SHIT
	sprintf(ksk_key, "/KSK@freeweb.%s.free", domain);

	/* Let's see if we can snarf this domain */
	pLog->Write(LOG_USER, LOG_USER,
				"Checking if domain '%s' is registered by someone else\r\n"
				"Note - this can take up to 3 minutes - please be patient...",
				(int)domain);
#ifdef XXXX
	page = pHttp->get("127.0.0.1", FPROXY_PORT, ksk_key);
	if (strstr(page, " 404") == NULL)
	{
		pLog->Write(LOG_CRITICAL, LOG_CRITICAL,
					"Sorry - it seems that someone else has registered '%s'",
					(int)domain);
		free(page);
		return 1;
	}
	free(page);		/* not needed anymore */
#else
	pLog->Write(LOG_CRITICAL, LOG_CRITICAL,
				"WARNING!!! - TEST OF DOMAIN AVAILABILITY HAS BEEN DISABLED");
#endif

	/* OK - we can have this domain - chain it in to configs, then update */
		pLog->Write(LOG_USER, LOG_CRITICAL,
					"Good news - domain '%s' is available - claiming it now...",
					(int)domain);

#endif

	/* Create and link in a site block */
	thissite = (Site *)malloc(sizeof(Site));
	strcpy(thissite->domainname, domain);
	strcpy(thissite->ksk_ptr, dns_key+1);	/* skip leading '/' in ksk key */
	thissite->ssk_pub[0] = '\0';
	thissite->ssk_priv[0] = '\0';
	strcpy(thissite->datecreated, pUtil->getgmtdate());
	strcpy(thissite->dateupdated, "00000000");
	strcpy(thissite->rootdir, dir);
	strncpy(thissite->description, description, 127);
	if (strlen(description) > 127)
		thissite->description[127] = '\0';
	thissite->generatedIndex = 0;
	thissite->firstfile = pSiteDir->scan_dir(dir);

	// ensure there aren't too many files
	if (pSiteDir->numFiles > MAX_FILES_PER_SITE)
	{
		char buf[256];

		pSiteDir->destroy_site_list(thissite->firstfile);

		free(thissite);
		sprintf(buf,
				"Warning - you have %d files in this directory\r\n"
				"Due to a Freenet restriction, you can only have\r\n"
				"approximately %d files in a FreeWeb site.\r\n"
				"You are welcome to insert as many files as you like,\r\n"
				"but you'll need to break up your FreeWeb directory into\r\n"
				"two or more folders, each containing less than %d files\n",
				pSiteDir->numFiles, MAX_FILES_PER_SITE, MAX_FILES_PER_SITE);
		MessageBox(0, buf, "FreeWeb Error - Too Many Files",
					MB_SYSTEMMODAL | MB_ICONEXCLAMATION);
		return 1;
	}

	// Check if there's an index.html
	sprintf(buf, "%s\\index.html", dir);
	if (GetFileAttributes(buf) == -1)
	{
		char buf[512];
		////SiteFile *thisdir;

		sprintf(buf,
				"The folder '%s' you have chosen\r\n"
				"does not contain an 'index.html' file.\r\n"
				"index.html files are necessary for FreeWeb\r\n"
				"Would you like me to create one?",
				dir);
		if (MessageBox(0, buf, "FreeWeb - Needs an 'Index.html' file",
						MB_SYSTEMMODAL | MB_ICONQUESTION | MB_YESNO)
			== IDNO
		)
		{
			// user doesn't want a machine-generated index.html
			pSiteDir->destroy_site_list(thissite->firstfile);
			free(thissite);
			MessageBox(0, "Site not created", "FreeWeb", MB_SYSTEMMODAL);
			return 1;
		}

		// mark site for later index.html generation
		thissite->generatedIndex = 1;
	}


	/* Insert into sites chain */
	thissite->next = pConfig->firstsite;
	pConfig->firstsite = thissite;
	pConfig->save();

	/* Now we can do the update */
	return 0;

//	save_publisher_configs();
//	return 0;
}		/* 'fpublish_add()' */


