// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// config.h: interface for the CConfig class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CONFIG_H__3EE36EE7_60E4_4309_871B_7E9CA0E677FD__INCLUDED_)
#define AFX_CONFIG_H__3EE36EE7_60E4_4309_871B_7E9CA0E677FD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#define SiteFile struct _sitefile
#define Site struct _site



//
// file list structure
//

#define FILELIST struct _filelist

FILELIST
{
	char		*pathname;		// malloc()'ed full pathname
	FILELIST	*next;
	char		mod_time[24];	// time of last mod, format yyyymmddhhmmss
};


//
// control structure for a site's file
//
 
SiteFile
{
	char filename[MAXFILELEN];		// obvious
	char chk[CHKKEYLEN+1];			// CHK this file is published as
	char time_published[24];		// local unix time for when this
	char needs_update;				// flag: 0 if already published and not changed
									// file was last published
	SiteFile *next;					// next file in chain
};



//
// Globally available FreeWeb configuration parameters
//

class CConfig  
{
public:
	char exepath[256];
	void deleteSite(char *domain);
	CConfig();
	virtual ~CConfig();

	int		load();
	int		save();

	char	*progpath;				// directory our executable resides in
	char	serverAddress[128];		// server address used for Freenet
	int		htl;					// hops to live for inserts
	int		htlReq;					// hops to live for requests

	int		fcpPort;				// FCP port number on server
	int		listenPort;				// port for listening for browser http requests

	char	extProxyEnabled;		// non-zero if using external proxy
	char	extProxyAddr[128];		// hostname of external proxy
	int		extProxyPort;			// port number of external proxy

	BOOL	blockWebAccess;			// block all access to mainstream Web
	BOOL	blockWebAtStartup;		// block web access at startup

	int		daysRegress;			// number of days to go back for browse requests
	int		trustKsks;				// set non-zero to access KSK site pointers without warning page

	int		maxInsertThreads;		// maximum number of concurrent insert threads

	Site	*firstsite;				// first site in linked list of sites
	Site	*lastsite;

private:
	int tokenise_line(char *buf, char *val1, char *val2);

};


//
// control structure for an individual site
//

Site
{
	char		domainname[DOMAINNAMEMAXLEN+1];
	char		ksk_ptr[DOMAINNAMEMAXLEN+19];	// ksk key pointing to ssk public key
	char		ssk_pub[64];					// Node's freeweb ssk public key
	char		ssk_priv[64];					// Node's freeweb ssk private key
	char		datecreated[12];				// yyyymmdd (GMT)
	char		dateupdated[12];				// yyyymmdd (GMT)
	char		rootdir[MAXDIRLEN];				// root directory of site's files
	char		description[128];				// brief description of this site
	Site		*next;							// next site in chain
	SiteFile	*firstfile;						// first file in this site
	char		generatedIndex;					// set if index.html is program-generated
	char		updating;
};


#endif // !defined(AFX_CONFIG_H__3EE36EE7_60E4_4309_871B_7E9CA0E677FD__INCLUDED_)
