// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// dropdlg.cpp : implementation file
//

#include "stdafx.h"
#include "fwpubgui.h"
#include "dropdlg.h"
#include "constants.h"
#include "config.h"

extern CConfig *pConfig;


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDropDlg dialog


CDropDlg::CDropDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDropDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_ICON_BRIGHT);

	//{{AFX_DATA_INIT(CDropDlg)
	m_DropFolder = _T("");
	m_DropDomain = _T("");
	m_DropDesc = _T("");
	//}}AFX_DATA_INIT
}


void CDropDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDropDlg)
	DDX_Text(pDX, IDC_DROP_FOLDER, m_DropFolder);
	DDV_MaxChars(pDX, m_DropFolder, 128);
	DDX_Text(pDX, IDC_DROP_DOMAIN, m_DropDomain);
	DDV_MaxChars(pDX, m_DropDomain, 64);
	DDX_Text(pDX, IDC_DROP_DESC, m_DropDesc);
	DDV_MaxChars(pDX, m_DropDesc, 127);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDropDlg, CDialog)
	//{{AFX_MSG_MAP(CDropDlg)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDropDlg message handlers

BOOL CDropDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDropDlg::OnHelp() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
	char buf[256];
	sprintf(buf, "%s\\%s", pConfig->progpath, "freeweb.hlp");
	ShellExecute(  0, "Open", buf, NULL, NULL, SW_SHOW);
	
}
