// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// fwpubgui.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"

#include "ezFCPlib.h"

#include "constants.h"
#include "sitelist.h"
#include "fwpubgui.h"
#include "fwpubguiDlg.h"
#include "addsite.h"
#include "config.h"
#include "log.h"
#include "util.h"
#include "sitedir.h"
//#include "gethttp.h"
#include "dropdlg.h"
#include "syncsite.h"
#include "configdlg.h"
#include "siteprop.h"
#include "freeweb.h"
#include "splash.h"
#include "FwProxyThread.h"

//#include "syncqueue.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


extern int WINAPI tray(HINSTANCE hInstance);


/////////////////////////////////////////////////////////////////////////////
// CFwpubguiApp

BEGIN_MESSAGE_MAP(CFwpubguiApp, CWinApp)
	//{{AFX_MSG_MAP(CFwpubguiApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFwpubguiApp construction

CFwpubguiApp::CFwpubguiApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CFwpubguiApp object

CFwpubguiApp theApp;

/////////////////////////////////////////////////////////////////////////////
// Declare pointers to class instances to make them global

CFwpubguiDlg	*pDlg;
CLog			*pLog;
CUtil			*pUtil;
CConfig			*pConfig;
CAddSite		*pAdd;
CSiteDir		*pSiteDir;
//CGetHttp		*pHttp;
CDropDlg		*pDropDlg;
CSiteList		*pSiteList;
CSyncSite		*pSyncSite;
CConfigDlg		*pConfigDlg;
CSiteProp		*pSiteProp;

//CSyncQueue		*pSyncQueue;

CFwProxyThread	*pProxy;
CSplashWnd		*pSplash;

///////////////////////////////////



/////////////////////////////////////////////////////////////////////////////
// CFwpubguiApp initialization

BOOL CFwpubguiApp::InitInstance()
{
	int nResponse;
	int fcpLaunchFailed = 0;

	// Declare one instance of every class
	CLog log;
	CFwpubguiDlg dlg;
	CUtil util;
	CConfig config;
	CAddSite addsite;
	CSiteDir sitedir;
//	CGetHttp http;
	CDropDlg dropdlg;
	CSiteList sitelist;
	CSyncSite syncsite;
//	CAboutDlg aboutdlg;
	CConfigDlg configdlg;
	CSiteProp siteprop;
//	CSyncQueue syncqueue;
	CFwProxyThread proxy;
	CSplashWnd splash;

	// set up global pointers to these class instances
	pDlg = &dlg;
	pLog = &log;
	pUtil = &util;
	pConfig = &config;
	pAdd = &addsite;
	pSiteDir = &sitedir;
//	pHttp = &http;
	pDropDlg = &dropdlg;
	pSiteList = &dlg.m_SiteList;	// subclass
	pSyncSite = &syncsite;
//	pAboutDlg = &aboutdlg;
	pConfigDlg = &configdlg;
	pSiteProp = &siteprop;
	pSplash = &splash;

//	pSyncQueue = &syncqueue;

	pProxy = &proxy;
	//pProxy = new CFwProxyThread;

//	char tmpbuf[2048];
//	sprintf(tmpbuf, "PATH=%s", getenv("PATH"));
//	MessageBox(0, tmpbuf, "debug", MB_SYSTEMMODAL);

	//char buf[80];
	//sprintf(buf, "Args = '%s'", this->m_lpCmdLine);
	//MessageBox(0, buf, "Prog args", MB_SYSTEMMODAL);

	if (this->m_lpCmdLine[0] != '\0' && !strcmp(this->m_lpCmdLine, "nogui"))
		pDlg->guiDisabled = 1;
	else
		pDlg->guiDisabled = 0;

	// set default logging level
	pLog->SetLevel(DEFLOG_UI, DEFLOG_FILE);

	// try to load in the configs
	if (pConfig->load() != 0)
	{
		MessageBox(0, "Failed to load FreeWeb sites configuration file",
					"FreeWeb Publisher - Error", MB_SYSTEMMODAL);
		return FALSE;
	}

	// get the sockets up
	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// find out if we know how to talk to freenet node
	while (pConfig->serverAddress == 0 || pConfig->fcpPort == 0)
	{
		if (pDlg->guiDisabled)
			return FALSE;

		// Hmmm, first time we've run this prog
		if (MessageBox(0, "I notice that this is the first time you've run FreeWeb Publisher\n\n"
						  "Is Freenet currently installed and running on your system?",
						  "FreeWeb Publisher - Configuration required!",
						  MB_SYSTEMMODAL | MB_YESNO | MB_DEFBUTTON1 | MB_ICONQUESTION)
			!= IDYES)
		{
			// User clicked 'no' - freenet is not installed
			MessageBox(0, "You cannot use FreeWeb until you have Freenet installed and working.\n"
						  "You can download Freenet from www.freenetproject.org",
						  "You need Freenet first",
						  MB_SYSTEMMODAL | MB_ICONEXCLAMATION);
			return FALSE;
		}

		// run config dialog
		pConfigDlg->DoDlg();

	}		// 'if (running for the first time)'

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
//	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Open up FCP connection
	while (fcpStartup(NULL, pConfig->fcpPort, pConfig->htl, 0) != 0)
	{
		// failed to connect to node
		if (MessageBox(0,
								"Sorry, I'm unable to communicate with the Freenet node\r\n"
								"Do you want to edit the FreeWeb configs and try again?",
								"FreeWeb: Problem communicating with Freenet node",
								MB_SYSTEMMODAL | MB_YESNO)
				== IDNO
		)
		{
			MessageBox(0, "FreeWeb will now exit", "FreeWeb: cannot communicate with Freenet node", MB_SYSTEMMODAL);
			exit(1);
		}

		// run config dialog
		pConfigDlg->DoDlg();
		continue;

	}			// 'while (pissing around trying to talk to node)'

	// do site updates without GUI if needed
	if (pDlg->guiDisabled)
	{
		// fire up sync thread in non-interactive mode
		pSyncSite = new CSyncSite;
		pDlg->UploadState = SYNCTHREAD_IDLE;
		pSyncSite->CreateThread(0, 0);
		Sleep(2000L);
		pDlg->UploadState = SYNCTHREAD_UPLOADING;
		while (pDlg->UploadState != SYNCTHREAD_IDLE)
			Sleep(5000L);
		pConfig->save();
		return FALSE;
	}

	m_pMainWnd = &dlg;

	pLog->Write(-1, LOG_DEBUG, "-----------------------------------------");

	// do the splash screen
	CCommandLineInfo cmdInfo;
    ParseCommandLine(cmdInfo);
	CSplashWnd::EnableSplashScreen(cmdInfo.m_bShowSplash);
	CSplashWnd::ShowSplashScreen((CWnd *)pDlg->m_hWnd);

	// fire up proxy thread
	pProxy->SetHtl(pConfig->htlReq);
	pProxy->Startup(pConfig->listenPort,
					pConfig->extProxyEnabled, pConfig->extProxyAddr, pConfig->extProxyPort,
					0, pConfig->blockWebAccess);

	// fire up tray thread
	tray(this->m_hInstance);

	// fire up sync thread
	pSyncSite->CreateThread(0, 0);

	// display main dialog, which will be promptly hidden
	Sleep(2000L);
	pSplash->ShowWindow(SW_HIDE);

	nResponse = dlg.DoModal();

	// sit here and twiddle our thumbs till prog is closed
	while (1)
		Sleep(1000L);

	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	pConfig->save();
	return FALSE;		// bye bye
}
