// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// fwpubguiDlg.cpp : implementation file
//

#include <process.h>

#include "stdafx.h"
#include "afxole.h"

#include "constants.h"
#include "sitelist.h"
#include "fwpubgui.h"
#include "fwpubguiDlg.h"
#include "config.h"
#include "util.h"
#include "log.h"
#include "sitedir.h"
#include "addsite.h"
#include "dropdlg.h"
#include "configdlg.h"

#include "addsitedialog.h"
#include "syncsite.h"

#include "freeweb.h"
#include "splash.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// pointers to global class instances

extern CLog			*pLog;
extern CUtil		*pUtil;
extern CConfig		*pConfig;
extern CSiteDir		*pSiteDir;
extern CAddSite		*pAdd;
extern CDropDlg		*pDropDlg;
extern CSiteList	*pSiteList;
extern CSyncSite	*pSyncSite;
//extern CAboutDlg	*pAboutDlg;
extern CConfigDlg	*pConfigDlg;
extern CFwpubguiDlg	*pDlg;


char statusText[1000000];

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;
	//{{AFX_MSG(CAboutDlg)
	afx_msg void OnButAboutFreenet();
	afx_msg void OnButAboutFreeweb();
	afx_msg void OnButAboutNitallica();
	afx_msg void OnButAboutPigdog();
	afx_msg void OnButAboutAmnesty();
	afx_msg void OnButAboutEff();
	virtual BOOL OnInitDialog();
	afx_msg void OnCancelMode();
	afx_msg void OnCaptureChanged(CWnd *pWnd);
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDI_ICON_BRIGHT);
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_BN_CLICKED(IDC_BUT_ABOUT_FREENET, OnButAboutFreenet)
	ON_BN_CLICKED(IDC_BUT_ABOUT_FREEWEB, OnButAboutFreeweb)
	ON_BN_CLICKED(IDC_BUT_ABOUT_NITALLICA, OnButAboutNitallica)
	ON_BN_CLICKED(IDC_BUT_ABOUT_PIGDOG, OnButAboutPigdog)
	ON_BN_CLICKED(IDC_BUT_ABOUT_AMNESTY, OnButAboutAmnesty)
	ON_BN_CLICKED(IDC_BUT_ABOUT_EFF, OnButAboutEff)
	ON_WM_CANCELMODE()
	ON_WM_CAPTURECHANGED()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFwpubguiDlg dialog

CFwpubguiDlg::CFwpubguiDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFwpubguiDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFwpubguiDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDI_ICON_BRIGHT);

	this->isShowing = 0;
	statusText[0] = '\0';
	UploadState = SYNCTHREAD_IDLE;
}

void CFwpubguiDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFwpubguiDlg)
	DDX_Control(pDX, IDC_SITELIST, m_SiteList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFwpubguiDlg, CDialog)
	//{{AFX_MSG_MAP(CFwpubguiDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUT_UPDATE_ALL, OnButUpdateAll)
	ON_BN_CLICKED(IDC_BUT_UPDATE_SELECTED, OnButUpdateSelected)
	ON_BN_CLICKED(IDC_BUT_ADDSITE, OnButAddsite)
	ON_BN_CLICKED(IDC_BUT_DELETESITE, OnButDeletesite)
	ON_WM_DROPFILES()
	ON_WM_CREATE()
	ON_BN_CLICKED(ID_HELP, OnHelp)
	ON_BN_CLICKED(IDC_BUT_ABOUT, OnButAbout)
	ON_BN_CLICKED(IDC_BUT_CONFIGURE, OnButConfigure)
	ON_WM_ENABLE()
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_BUT_HIDE, OnButtonHide)
	ON_BN_CLICKED(IDC_GATEWAY, OnGateway)
	ON_WM_CANCELMODE()
	ON_BN_CLICKED(IDC_SITEPROP, OnSiteprop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFwpubguiDlg message handlers

BOOL CFwpubguiDlg::OnInitDialog()
{
	AfxOleInit();
	CDialog::OnInitDialog();

	// get pointer to status window class
	CEdit *pStatusWindow;

	// Write it back to window, then scroll up
	pStatusWindow = (CEdit *)GetDlgItem(IDC_STATUS);
	pStatusWindow->SetWindowText(statusText);
	pStatusWindow->LineScroll(1024, 0);

	// set 'is showing' flag
	this->isShowing = 1;

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	UploadState = SYNCTHREAD_IDLE;
	strcpy(selectedSite, "free");

	m_SiteList.FormatWindow();
	m_SiteList.Refresh();

	// fire up sync thread
//	pSyncSite->CreateThread(0, 0);

	// these are for debugging
	//return TRUE;
	//Sleep(10000L);

	this->ShowWindow(SW_HIDE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFwpubguiDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CFwpubguiDlg::OnDestroy()
{
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFwpubguiDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFwpubguiDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CFwpubguiDlg::WriteStatus(char *msg)
{
	static int thisline = 0;
	static char buf[8000000] = "";

	// ignore '------' session separators
	if (!strncmp(msg, "----------", 10))
		return;

	// get pointer to status window class
	CEdit *pStatusWindow;

	// Fetch contents of status window
//	pStatusWindow->GetWindowText(buf, 800000);

	// Add newline if this is not the first line
//	if (*buf)
	strcat(statusText, "\r\n");

	// Now add this message
	strcat(statusText, msg);

	// don't write if dialog hasn't been shown yet
	if (!isShowing)
		return;

	// Write it back to window, then scroll up
	pStatusWindow = (CEdit *)GetDlgItem(IDC_STATUS);
	pStatusWindow->SetWindowText(statusText);
	pStatusWindow->LineScroll(1024, 0);
}



void CFwpubguiDlg::OnButUpdateAll() 
{
	static int i = 1;

	// TODO: Add your control notification handler code here
	if (UploadState != SYNCTHREAD_IDLE)
	{
		MessageBox("Please wait til current site synchronization operations are finished",
					PROGNAME,
					MB_SYSTEMMODAL);
		return;
	}

	strcpy(selectedSite, "all");
	UploadState = SYNCTHREAD_UPLOADING;
	pLog->Write(LOG_DEBUG, LOG_DEBUG, "Triggering sites update thread");

}

void CFwpubguiDlg::OnButUpdateSelected() 
{
	if (UploadState != SYNCTHREAD_IDLE)
	{
		MessageBox("Please wait til current site synchronization operations are finished",
					PROGNAME,
					MB_SYSTEMMODAL);
		return;
	}

	char *site = m_SiteList.GetSelectedDomain();

	if (site != NULL && *site)
	{
		strcpy(selectedSite, m_SiteList.GetSelectedDomain());

		// hack - strip off the '.free' from the end
		char *dotfree = strrchr(selectedSite, '.');
		if (dotfree != NULL && !strcmp(dotfree, ".free"))
			*dotfree = '\0';
		UploadState = SYNCTHREAD_UPLOADING;
	}
	else
		MessageBox("You must select a site to freshen", PROGNAME, MB_SYSTEMMODAL);

}

void CFwpubguiDlg::OnButAddsite() 
{
	// TODO: Add your control notification handler code here
	if (UploadState != SYNCTHREAD_IDLE)
	{
		MessageBox("Please wait until current site synchronization operations are finished",
					PROGNAME,
					MB_SYSTEMMODAL);
		return;
	}
	
	static AddSiteDialog dlg;
	char *domain;
	char *dir;
	char *description;

	dlg.DoModal();

	domain = dlg.m_Add_Site_Domain.GetBuffer(1);
	dir = dlg.m_Add_Site_Dir.GetBuffer(1);
	description = dlg.m_Add_Site_Desc.GetBuffer(1);

	if (pAdd->add(domain, dir, description) == 0)
		pLog->Write(LOG_DEBUG, LOG_DEBUG, "Successfully added site '%s' at '%s'", (int)domain, (int)dir);
	else
		pLog->Write(LOG_DEBUG, LOG_DEBUG, "Failed to add site '%s' at '%s'", (int)domain, (int)dir);

	// Refresh sites list and save
	m_SiteList.Refresh();
	pConfig->save();
}

void CFwpubguiDlg::OnButDeletesite() 
{
	char buf[128];
	char *domain = m_SiteList.GetSelectedDomain();

	if (UploadState != SYNCTHREAD_IDLE)
	{
		MessageBox("Please wait til current site synchronization operations are finished",
					PROGNAME,
					MB_SYSTEMMODAL);
		return;
	}

	sprintf(buf, "Are you sure you want to delete site '%s'?", domain);
	if (domain == NULL)
	{
		MessageBox("You must select a site to delete", PROGNAME, MB_OK | MB_SYSTEMMODAL);
		return;
	}
	if (MessageBox(buf, PROGNAME, MB_YESNO | MB_SYSTEMMODAL) != IDYES)
		return;

	pConfig->deleteSite(domain);
	pSiteList->Refresh();
}

void CFwpubguiDlg::OnCancel() 
{
	MessageBox("Sending FreeWeb window to the system tray", "FreeWeb",
				MB_SYSTEMMODAL | MB_ICONINFORMATION);

	this->ShowWindow(SW_HIDE);
	return;

	// TODO: Add extra cleanup here
	if (UploadState != SYNCTHREAD_IDLE)
	{
		MessageBox("Can't quit until current site synchronization operations are finished",
					PROGNAME,
					MB_SYSTEMMODAL);
		return;
	}

	// goodbye
	CDialog::OnCancel();
}


void CFwpubguiDlg::OnDropFiles(HDROP hDropInfo) 
{
	// TODO: Add your message handler code here and/or call default
	UINT        uNumFiles;
	TCHAR       dirPath[MAX_PATH];
	char		domainName[65] = "";
	char		desc[128] = "";
	LVFINDINFO  rlvFind = { LVFI_STRING, dirPath };
	DWORD		attribs;

	CString		csPathname;
	CString		csExpandedFilename;

	if (UploadState != SYNCTHREAD_IDLE)
	{
		MessageBox("Please wait until current site synchronization operations are finished",
					PROGNAME,
					MB_SYSTEMMODAL);
		return;
	}

    // Get the # of files being dropped.
    if ((uNumFiles = DragQueryFile ( hDropInfo, -1, NULL, 0 )) != 1)
	{
		MessageBox("You can only add one site folder at a time",
					"Error - FreeWeb Publisher",
					MB_ICONEXCLAMATION | MB_ICONSTOP | MB_SYSTEMMODAL
					);
	    DragFinish (hDropInfo);
		return;
	}

	// Get the filename from the HDROP info.
	if (DragQueryFile(hDropInfo, 0, dirPath, MAX_PATH ) <= 0)
	{
		MessageBox("Severe problem - can't access folder", "FreeWeb fatal error",
					MB_ICONSTOP | MB_SYSTEMMODAL
					);
	    DragFinish (hDropInfo);
		return;
	}

	// Try to expand shortcut
	csPathname = dirPath;
	csExpandedFilename = pUtil->ExpandShortcut(csPathname);
	if(!csExpandedFilename.IsEmpty())
	{
		strcpy(dirPath, csExpandedFilename);
	}

	attribs = GetFileAttributes(dirPath);

	// Spit if it's not a folder
//	if ((rFileInfo.dwAttributes & SFGAO_FOLDER) == 0)
	if (!(attribs & FILE_ATTRIBUTE_DIRECTORY))
	{
		MessageBox("You can only add folders - not individual files",
					"Error - FreeWeb Publisher",
					MB_ICONEXCLAMATION | MB_SYSTEMMODAL
					);
	    DragFinish (hDropInfo);
		return;
	}

	pDropDlg->m_DropDomain.Empty();
	pDropDlg->m_DropFolder.Empty();
	pDropDlg->m_DropFolder.Insert(0, dirPath);
	pDropDlg->DoModal();
	strcpy(domainName, pDropDlg->m_DropDomain);
	if (domainName[0] == '\0')
	{
		MessageBox("Add Site aborted - no domain name chosen", "FreeWeb Publisher",
					MB_ICONEXCLAMATION | MB_SYSTEMMODAL);
	    DragFinish (hDropInfo);
		return;
	}

	strncpy(desc, pDropDlg->m_DropDesc, 127);
	if (pDropDlg->m_DropDesc > 127)
		desc[127] = '\0';

	// phew! validation finished - try to add domain
	if (pAdd->add(domainName, dirPath, desc) == 0)
		pLog->Write(LOG_USER, LOG_USER, "Successfully added site '%s' at '%s'", (int)domainName, (int)dirPath);
	else
		pLog->Write(LOG_USER, LOG_USER, "Failed to add site '%s' at '%s'", (int)domainName, (int)dirPath);

	// Refresh sitelist window and save new configs to file
	m_SiteList.Refresh();
	pConfig->save();

    // send to add routine
	DragFinish(hDropInfo);
}	

int CFwpubguiDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	return 0;
}




void CFwpubguiDlg::OnHelp() 
{
	// TODO: Add your control notification handler code here
	char buf[256];
	sprintf(buf, "%s\\help\\index.html", pConfig->progpath);
	ShellExecute(  0, "Open", buf, NULL, NULL, SW_SHOW);

//	HWND hwnd =
//	   HtmlHelp(
//             GetDesktopWindow(),
//             "freeweb.chm::/index.html>mainwin",
//             HH_DISPLAY_TOPIC,
//             NULL) ;


	return;
}

void CFwpubguiDlg::OnButAbout() 
{
	if (UploadState != SYNCTHREAD_IDLE)
	{
		MessageBox("Please wait until current site synchronization operations are finished",
					PROGNAME,
					MB_SYSTEMMODAL);
		return;
	}

 	static CAboutDlg thisdlg;
	thisdlg.DoModal();
}

void CFwpubguiDlg::OnButConfigure() 
{
	int configUpdated = 0;

	//if (UploadState != SYNCTHREAD_IDLE)
	//{
	//	MessageBox("Please wait until current site synchronization operations are finished",
	//				PROGNAME,
	//				MB_SYSTEMMODAL);
	//	return;
	//}

	pConfigDlg->DoDlg();
	if (configUpdated)
	{
		while (UploadState != SYNCTHREAD_IDLE)
			Sleep(1000L);

		// server port and/or htl have changed - signal sync thread to signal changes
		UploadState = SYNCTHREAD_SETPARMS;
		Sleep(1000L);	// give sync thread a chance to pick up
	}
}

void CAboutDlg::OnButAboutFreenet() 
{
	// TODO: Add your control notification handler code here
	ShellExecute(0, "open", "http://www.freenetproject.org", NULL, NULL, SW_SHOW);
}

void CAboutDlg::OnButAboutFreeweb() 
{
	// TODO: Add your control notification handler code here
	ShellExecute(0, "open", "http://freeweb-hq.da.ru", NULL, NULL, SW_SHOW);
}

void CAboutDlg::OnButAboutNitallica()
{
	// TODO: Add your control notification handler code here
	ShellExecute(0, "open", "http://www.nitallica.com", NULL, NULL, SW_SHOW);
}

void CAboutDlg::OnButAboutPigdog() 
{
	// TODO: Add your control notification handler code here
	ShellExecute(0, "open", "http://www.pigdog.org", NULL, NULL, SW_SHOW);
	
}

void CAboutDlg::OnButAboutAmnesty() 
{
	// TODO: Add your control notification handler code here
	ShellExecute(0, "open", "http://www.amnesty.org", NULL, NULL, SW_SHOW);
	
}

void CAboutDlg::OnButAboutEff() 
{
	// TODO: Add your control notification handler code here
	ShellExecute(0, "open", "http://www.eff.org", NULL, NULL, SW_SHOW);
	
}

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	pDlg->ShowWindow(SW_HIDE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAboutDlg::OnCancelMode() 
{
	CDialog::OnCancelMode();
	pDlg->ShowWindow(SW_RESTORE);
	
	// TODO: Add your message handler code here
	
}

void CAboutDlg::OnCaptureChanged(CWnd *pWnd) 
{
	// TODO: Add your message handler code here
	
	CDialog::OnCaptureChanged(pWnd);
}

void CFwpubguiDlg::OnEnable(BOOL bEnable) 
{
	CDialog::OnEnable(bEnable);
	
	// TODO: Add your message handler code here
	
}

void CFwpubguiDlg::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	
	// TODO: Add your message handler code here
	
}

void CFwpubguiDlg::OnButtonHide() 
{
	// TODO: Add your control notification handler code here
	this->ShowWindow(SW_HIDE);
}

void CAboutDlg::OnOK() 
{
	// TODO: Add extra validation here
	CDialog::OnOK();
	pDlg->ShowWindow(SW_RESTORE);
}

void CFwpubguiDlg::OnGateway() 
{
	// TODO: Add your control notification handler code here
	ShellExecute(pDlg->m_hWnd, "open", "http://free", NULL, NULL, SW_SHOW);
	
	
}

void CFwpubguiDlg::OnSiteprop() 
{
	// TODO: Add your control notification handler code here
	////char buf[128];
	char *domain = m_SiteList.GetSelectedDomain();

	if (UploadState != SYNCTHREAD_IDLE)
	{
		MessageBox("Please wait til current site synchronization operations are finished",
					PROGNAME,
					MB_SYSTEMMODAL);
		return;
	}

	if (domain == NULL)
	{
		MessageBox("Please select a site first", PROGNAME, MB_OK | MB_SYSTEMMODAL);
		return;
	}

	pSiteList->siteProperties();
	pSiteList->Refresh();
	
}
