// gethttp.c: implementation of the CGetHttp class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <windows.h>
#include <io.h>
#include <time.h>

#include "stdafx.h"
#include "fwpubgui.h"
#include "gethttp.h"
#include "util.h"
#include "log.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGetHttp::CGetHttp()
{

}

CGetHttp::~CGetHttp()
{

}


extern CLog			*pLog;
extern CUtil		*pUtil;


#define MAX_PAGE    (1024*64)

char    PageBuffer[MAX_PAGE];




char *CGetHttp::get(char *host, int port, char *path)
{
    struct sockaddr     SockAddr;
    SOCKET              Socket;

    if(GetAddr(host, port, &SockAddr))
    {
        int     Status;

        Socket = socket(AF_INET, SOCK_STREAM, 0);
        Status = connect(Socket, &SockAddr, sizeof(SockAddr));
        if(Status >= 0)
        {
            DWORD   StartTime, EndTime;
            char    Request[512];
            char*   Rover   = PageBuffer;
            int     Read;

            sprintf(Request, "GET %s HTTP/1.0\n\n", path);
            send(Socket, Request, strlen(Request), 0);

            StartTime = GetTickCount();
            for(Read=0;Read < MAX_PAGE;)
            {
                int     ThisRead;

                ThisRead = recv(Socket, Rover, MAX_PAGE-Read, 0);
                if(ThisRead == SOCKET_ERROR || ThisRead == 0)
                    break;
                else
                {
                    Read    += ThisRead;
                    Rover   += ThisRead;
                }
            }
            EndTime = GetTickCount();

//          printf("%d milliseconds to read %d-byte page\n", EndTime-StartTime, Read);
            closesocket(Socket);
        }
        else
		{
//          fprintf(stderr, "connect failed (%d)\n", WSAGetLastError());
			;
		}
    }
    else
	{
        fprintf(stderr, "Can't map hostname '%s'\n", host);
		;
	}

	return pUtil->strsav(NULL, PageBuffer);

}		/* 'GetHttp()' */




int CGetHttp::GetAddr(const char* HostName, int Port, struct sockaddr* Result)
{
    struct hostent*     Host;
    SOCKADDR_IN         Address;

    memset(Result, 0, sizeof(*Result));
    memset(&Address, 0, sizeof(Address));

    Host = gethostbyname(HostName);
    if(Host != NULL)
    {
        Address.sin_family  = AF_INET;
        Address.sin_port    = htons((short)Port);
        memcpy(&Address.sin_addr, Host->h_addr_list[0], Host->h_length);
        memcpy(Result, &Address, sizeof(Address));
    }
    return Host != NULL;
}

