// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//


// log.cpp: implementation of the CLog class.
//
//////////////////////////////////////////////////////////////////////

#include <string.h>
#include <stdio.h>

#include "stdafx.h"
#include "constants.h"
#include "sitelist.h"

#include "fwpubgui.h"
#include "fwpubguidlg.h"
#include "log.h"
#include "util.h"
#include "config.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//
// Import other class instances

extern CFwpubguiDlg *pDlg;
extern CUtil		*pUtil;
extern CConfig		*pConfig;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLog::CLog()
{
	this->m_locked = FALSE;
}

CLog::~CLog()
{

}


void CLog::SetLevel(int level_ui, int level_file)
{
	loglevel_ui = level_ui;
	loglevel_file = level_file;
}


void CLog::Write(int levelUi, int levelFile,
				 char *msg)
{
	char buf[LOG_BUFSIZE];
	FILE *fp;

	// wait for exclusive access
	while (m_locked)
		Sleep(50L);
	m_locked = TRUE;

	// Write to file if required
	if (levelFile >= loglevel_file)
	{
		sprintf(buf, "%s\\%s", pConfig->progpath, LOG_FILE);
		if ((fp = fopen(buf, "at")) == NULL)
			return;

		fprintf(fp, "%s|%s\n", pUtil->getgmtdatetime(), msg);
		fclose(fp);
	}

	if (levelUi == LOG_CRITICAL)
		MessageBox(0, msg, "FreeWeb Publisher - Error!", MB_SYSTEMMODAL);
	else if (levelUi >= loglevel_ui && !pDlg->guiDisabled)
		pDlg->WriteStatus(msg);
	
	// release lock
	m_locked = FALSE;
}


void CLog::Write(int levelUi, int levelFile,
				 char *fmt,
				 int arg1)
{
	char buf[LOG_BUFSIZE];

	sprintf(buf, fmt, arg1);
	Write(levelUi, levelFile, buf);
}


void CLog::Write(int levelUi, int levelFile,
				 char *fmt,
				 int arg1, int arg2)
{
	char buf[LOG_BUFSIZE];

	sprintf(buf, fmt, arg1, arg2);
	Write(levelUi, levelFile, buf);
}


void CLog::Write(int levelUi, int levelFile,
				 char *fmt,
				 int arg1, int arg2, int arg3)
{
	char buf[LOG_BUFSIZE];

	sprintf(buf, fmt, arg1, arg2, arg3);
	Write(levelUi, levelFile, buf);
}


void CLog::Write(int levelUi, int levelFile,
				 char *fmt,
				 int arg1, int arg2, int arg3, int arg4)
{
	char buf[LOG_BUFSIZE];

	sprintf(buf, fmt, arg1, arg2, arg3, arg4);
	Write(levelUi, levelFile, buf);
}


void CLog::Write(int levelUi, int levelFile,
				 char *fmt,
				 int arg1, int arg2, int arg3, int arg4, int arg5)
{
	char buf[LOG_BUFSIZE];

	sprintf(buf, fmt, arg1, arg2, arg3, arg4, arg5);
	Write(levelUi, levelFile, buf);
}


