// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// log.h: interface for the CLog class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LOG_H__C51956BA_9314_46B5_A3DB_096679059D07__INCLUDED_)
#define AFX_LOG_H__C51956BA_9314_46B5_A3DB_096679059D07__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//////////////////////////////////////////
// Define logging threshold levels
//

#define LOG_DEBUG		0		// only used for debugging
#define LOG_VERBOSE		1		// extra guff for users
#define LOG_USER		2		// normal output for users
#define LOG_IMPORTANT	3		// messages user needs to see
#define LOG_CRITICAL	4		// must-see


class CLog  
{
public:
	CLog();
	virtual ~CLog();
	void SetLevel(int level_ui, int level_file);
	void Write(int levelUi, int levelFile, char *msg);
	void Write(int levelUi, int levelFile, char *fmt, int arg1);
	void Write(int levelUi, int levelFile, char *fmt, int arg1, int arg2);
	void Write(int levelUi, int levelFile, char *fmt, int arg1, int arg2, int arg3);
	void Write(int levelUi, int levelFile, char *fmt, int arg1, int arg2, int arg3, int arg4);
	void Write(int levelUi, int levelFile, char *fmt, int arg1, int arg2, int arg3, int arg4, int arg5);

private:
	int loglevel_ui;	// threshhold set by SetLevel()
	int loglevel_file;	// threshhold set by SetLevel()

protected:
	BOOL m_locked;
};

#endif // !defined(AFX_LOG_H__C51956BA_9314_46B5_A3DB_096679059D07__INCLUDED_)


