// syncqueue.cpp: implementation of the CSyncQueue class.
//
//////////////////////////////////////////////////////////////////////

/*
 * FREENET freeweb
 *
 * queue.c
 *
 * Routines for building the Freenet insert queue, and
 * keeping track of the insertions as they happen
 */

#include <stdio.h>
#include <stdlib.h>

//#include "fwpublish.h"

#include "stdafx.h"
#include "fwpubgui.h"
#include "constants.h"
#include "config.h"
#include "syncqueue.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSyncQueue::CSyncQueue()
{
	QueueHead = NULL;

}

CSyncQueue::~CSyncQueue()
{

}



/*
 * NextFreeJob()
 *
 * Returns a pointer to the next job on the queue that's free of
 * dependents and is waiting to run
 */

INSERTQ *CSyncQueue::NextFreeJob()
{
	char alldone = 0;

	return NextFreeJobRecurse(QueueHead, &alldone);
}



/*
 * NextFreeJobRecurse()
 *
 * Workhorse of NextFreeJob()
 *
 * Does a depth-first recursive search of the job queue tree,
 * deleting any complete jobs it finds, and returns the first
 * waiting job without prerequisites
 *
 * warning - this routine may fry your brain
 *
 * Arguments:
 *
 *		node	part of the tree to search at or below
 *
 * Returns:
 *
 *		pointer to a ready job, or NULL if none found here
 *		Also, writes 1 to alldone if all prereqs of given job are complete
 */

INSERTQ *CSyncQueue::NextFreeJobRecurse(INSERTQ *node, char *alldone)
{
	INSERTQ *jobfound;
//	INSERTQ *tempjob;
//	INSERTQ *tempjob1;

	if (node == NULL)
		/* nothing to do */
		return NULL;

	/* Investigate the tree more deeply */
	if (node->status == INSERTQ_STATUS_WAITING)
	{
		if (node->prereq == NULL)
			/* this job is ready and has no prerequisites - go with it */
			return node;
		else
		{
			/* is one of the prerequisites free? */
			if ((jobfound = NextFreeJobRecurse(node->prereq, alldone)) != NULL)
				/* yes - return it */
				return jobfound;
			else if (*alldone)
				/* All prerequisites are done - can launch this one */
				return node;
		}
	}

	if (node->sibling == NULL)
	{
		/* this one's a leaf */
		if (node->status == INSERTQ_STATUS_DONE)
			*alldone = 1;
		return NULL;
	}

	/* search siblings */
	if ((jobfound = NextFreeJobRecurse(node->sibling, alldone)) != NULL)
		return jobfound;
	else
		/* either way, this one ain't waiting and ready */
		return NULL;

}		// 'NextFreeJobRecurse()'


/*
 * AddItem
 *
 * Inserts an insert job into the queue tree,
 * optionally as a prerequisite of another item
 *
 * Arguments:
 *
 *		dependent	queue item depending on this one, or NULL if none
 *
 *		type		one of the INSERTQ_TYPE_ type tokens
 *
 *		item		points to either a site block or file block, containing
 *					info on what to insert
 *
 * Returns
 *
 *		pointer to queue entry created for this job
 */

INSERTQ *CSyncQueue::AddItem(INSERTQ *dependent, char type, INSERTQITEM item)
{
	INSERTQ *thisjob;

	/* any dependents? */
	if (dependent == NULL)
	{
		/* is queue currently empty? */
		if (QueueHead == NULL)
		{
			/* This is the first one - create and return it */
			QueueHead = CreateQueueItem(type, item);
			return QueueHead;
		}

		/* no - add as a sibling of head */
		thisjob = CreateQueueItem(type, item);
		thisjob->sibling = QueueHead->sibling;
		QueueHead->sibling = thisjob;
		return thisjob;
	}

	/* add under dependent item */
	thisjob = CSyncQueue::CreateQueueItem(type, item);
	thisjob->sibling = dependent->prereq;
	dependent->prereq = thisjob;
	return thisjob;

}		/* 'add_queue_item()' */


INSERTQ *CSyncQueue::CreateQueueItem(char type, INSERTQITEM item)
{
	INSERTQ *thisjob = (INSERTQ *)malloc(sizeof(INSERTQ));

	thisjob->type = type;
	thisjob->status = INSERTQ_STATUS_WAITING;
	thisjob->details = item;
	thisjob->sibling = NULL;
	thisjob->prereq = NULL;

	return thisjob;

}		/* 'create_queue_item()' */



void CSyncQueue::ResetQueue()
{
	QueueHead = NULL;
}

