// syncqueue.h: interface for the CSyncQueue class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SYNCQUEUE_H__247FE735_1917_4928_802D_4ED814E8CD2E__INCLUDED_)
#define AFX_SYNCQUEUE_H__247FE735_1917_4928_802D_4ED814E8CD2E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


/*
 * insert queue structure
 *
 * defines a hierarchical queue for performing freenet inserts
 */


#define INSERTQITEM struct _insertqitem

INSERTQITEM
{
	Site		*site;
	SiteFile	*file;
};


#define INSERTQ struct _insertq

INSERTQ
{
	char		type;		/* one of the values above */
	char		status;		/* ditto */
	INSERTQITEM details;
	INSERTQ		*sibling;	/* jobs at same precedence */
	INSERTQ		*prereq;	/* chain of prerequisite jobs */
};



class CSyncQueue
{
public:
	CSyncQueue();
	virtual ~CSyncQueue();

	INSERTQ *NextFreeJob();
	INSERTQ *AddItem(INSERTQ *dependent, char type, INSERTQITEM item);
	INSERTQ *JobsInProgress[MAXCONCURRENTINSERTS];
	void	ResetQueue();
	INSERTQ *QueueHead;

private:
	INSERTQ *NextFreeJobRecurse(INSERTQ *node, char *alldone);
	INSERTQ *CreateQueueItem(char type, INSERTQITEM item);

};


#define INSERTQ_TYPE_SVKROOT	'V'
#define INSERTQ_TYPE_KSKPTR		'K'
#define INSERTQ_TYPE_CHKFILE	'F'
#define INSERTQ_TYPE_SSKMAP		'M'

#define INSERTQ_STATUS_WAITING	'W'
#define INSERTQ_STATUS_INPROG	'I'
#define INSERTQ_STATUS_DONE		'D'


#ifdef xzx
types of inserts:
- SVK root for domain
- KSK domain ptr
- SSK with map metadata
- CHK for regular file

ksk <- svk
ssk map <- svk
		<- all chks

sequence of insertion:
	1. svk
	2. kskptr if needed
	2. chks
	3. ssk map

#endif



#endif // !defined(AFX_SYNCQUEUE_H__247FE735_1917_4928_802D_4ED814E8CD2E__INCLUDED_)
