// syncsite.cpp: implementation of the CSyncSite class.
//
//////////////////////////////////////////////////////////////////////

/*
 * Class to implement auto-updates of all sites
 */

#include <stdio.h>
#include <string.h>
//#include <windows.h>
//#include <winbase.h>
//#include <winuser.h>

#include "stdafx.h"

#include "ezFCPlib.h"

#include "freeweb.h"

#include "fwpubgui.h"
#include "fwpubguidlg.h"
#include "syncsite.h"
#include "constants.h"
#include "config.h"
#include "constants.h"
#include "sitedir.h"
#include "sitelist.h"
#include "util.h"
#include "log.h"
#include "gethttp.h"

#include "syncqueue.h"
#include "syncthreads.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CLog			*pLog;
extern CConfig		*pConfig;
extern CLog			*pLog;
extern CSiteDir		*pSiteDir;
extern CUtil		*pUtil;
extern CSiteList	*pSiteList;
extern CFwpubguiDlg	*pDlg;
extern CGetHttp		*pHttp;

extern CSyncQueue	*pSyncQueue;



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSyncSite::CSyncSite()
{
}

CSyncSite::~CSyncSite()
{

}


/////////////////////////////////////
// Tells whether any site uploads are
// currently in progress
//

BOOL CSyncSite::InitInstance()
{
//	pLog->Write(LOG_DEBUG, LOG_DEBUG, "Site sync thread started");

	// we stay in this loop waiting for signal from main thread
	while (1)
	{
		Sleep(1000L);
		if (pDlg->UploadState == SYNCTHREAD_IDLE)
			continue;

		// do we just need to send new parameters to Freenet?
		if (pDlg && pDlg->UploadState == SYNCTHREAD_SETPARMS)
		{
			// send new parms to Freenet
			pLog->Write(LOG_DEBUG, LOG_DEBUG,
						"htl='%d'", (int)pConfig->htl);
			pDlg->UploadState = SYNCTHREAD_IDLE;
			continue;
		}

		// otherwise, we've been told to synchronise sites
		pLog->Write(LOG_DEBUG, LOG_DEBUG, "Site sync: starting syncs");

		// we've got the go-ahead from the main thread
		UploadSite(pDlg->guiDisabled ? "all" : pDlg->selectedSite);
//		pSiteList->Refresh();

		// tell the main thread we've finished
		pDlg->UploadState = SYNCTHREAD_IDLE;
		strcpy(pDlg->selectedSite, "all");

	}		// 'while (1)'
}



int CSyncSite::UploadAll()
{
	return UploadSite("all");
}



/*
 * UploadSite()
 *
 * Automatically updates all sites in a given map file
 *
 * Arguments:
 *
 *		domain		individual domain to update, or 'all'
 *		days		number of days ahead to update.
 *
 * Returns:
 *
 *		0 if successful
 *		nonzero if failed
 */

int CSyncSite::UploadSite(char *domain)
{
	char		registered_new_domains = 0;
	int			days = 0;
	Site		*thissite;
	SiteFile	*filelist;
	SiteFile	*filelist_old;
	SiteFile	*thisfile;
	SiteFile	*thisfile_old;
	INSERTQ		*svkjob;
	INSERTQ		*kskjob;
	INSERTQ		*chkjob;
	INSERTQ		*sskjob;
	INSERTQITEM	item;
	char		new_msk_needed = 0;
	char		needs_svkroot;
	char		needs_kskptr;
	char		needs_sskmap;
	////char		buf[256];

	pLog->Write(LOG_DEBUG, LOG_DEBUG, "-----------------------------------------");
	pLog->Write(LOG_DEBUG, LOG_DEBUG, "Freshening Site '%s'", (int)domain);

	/* go through all sites, update as needed */
	for (thissite = pConfig->firstsite;
		thissite != NULL;
		thissite = thissite->next)
	{
		char *thisdom = thissite->domainname;

		/* Do we need to update this site? */
		if (strcmp(domain, "all") && strcmp(domain, thisdom))
			continue;	/* no - skip this one */

		/* Is this site up to date? */
		if (strcmp(thissite->dateupdated, pUtil->getgmtdate()) >= 0)
		{
			pLog->Write(LOG_DEBUG, LOG_DEBUG, "domain '%s' is up to date", (int)thisdom);
			continue;
		}

		//
		// Found a site needing updating
		//

		if (!pDlg->guiDisabled)
		{
			thissite->updating = 1;
			//strcpy(thissite->dateupdated, "U");	// mark update date as 'U' to indicate updating
			pSiteList->Refresh();
		}

		needs_svkroot = (thissite->ssk_pub[0] == '\0') ? 1 : 0;
//		needs_kskptr = (thissite->ksk_ptr[0] == '\0') ? 1 : 0;
		needs_kskptr = needs_svkroot;
		needs_sskmap = 1;

		// Go no further with this site unless we can snarf its domain
			pLog->Write(LOG_USER, LOG_USER,
						"Checking if domain '%s' is registered by someone else",
						(int)thisdom);

			// new - check if domain is registered
			if (domainIsRegistered(thisdom))
			{
				pLog->Write(LOG_CRITICAL, LOG_CRITICAL,
							"Sorry - it seems that someone else has registered '%s'",
							(int)thisdom);
				thissite->updating = 0;
				pSiteList->Refresh();
				continue;
			}


		/* back up this site's file list */
		filelist_old = thissite->firstfile;

		// if needed, generate an index.html file
		// just generate a dummy now so it will show up in the listing
		// it's not nice, i know, but it solves a chicken-and-egg problem
		if (thissite->generatedIndex)
		{
			char buf[256];
			FILE *fp;

			sprintf(buf, "%s\\index.html", thissite->rootdir);
			fp = fopen(buf, "a");
			fclose(fp);
		}
			
		/* Scan this site's directory and chain it in to site */
		filelist = pSiteDir->scan_dir(thissite->rootdir);
		thissite->firstfile = filelist;

		/* mark each file that has a chk and hasn't changed */
		for (thisfile = filelist; thisfile != NULL; thisfile = thisfile->next)
		{
			/* Try to find the file in existing configs for this site */
			for (thisfile_old = filelist_old;
				thisfile_old != NULL;
				thisfile_old = thisfile_old->next)
			{
				if (!strcmp(thisfile->filename, thisfile_old->filename))
				{
					/* file is previously known */
					/* see if it has a CHK and that dates match */
					if ((thisfile_old->chk[0] != '\0')
						&&
						(strcmp(thisfile->time_published,
								thisfile_old->time_published) <= 0)
						)
					{
						/* file hasn't changed - reset update flag */
						thisfile->needs_update = 0;

						/* And grab its CHK since we're re-using it */
						strcpy(thisfile->chk, thisfile_old->chk);
					}
					else
						needs_sskmap = 1;
					break;
				}
			}

			/* Was the file previously known? */
			if (thisfile_old == NULL)
				/* no - we need a new map */
				needs_sskmap = 1;

		}		/* 'for (each file in site's directory)' */

		//
		// if needed, generate an index.html listing all the files
		//
		if (thissite->generatedIndex)
			pSiteDir->generate_index_html(thisdom, thissite->rootdir, filelist);

		svkjob = kskjob = chkjob = sskjob = NULL;

		/* ok - now write jobs to queue tree */
		if (needs_sskmap)
		{
			item.site = thissite;
			sskjob = pSyncQueue->AddItem(NULL, INSERTQ_TYPE_SSKMAP, item);
		}

		if (needs_kskptr)
		{
			item.site = thissite;
			kskjob = pSyncQueue->AddItem(sskjob, INSERTQ_TYPE_KSKPTR, item);
		}

		// do the uploading
		if (needs_svkroot)
		{
			////char dns_key[128];
			////char *page;
			HFCP *hfcp;

			item.site = thissite;

			// create a keypair for this domain
			pLog->Write(LOG_VERBOSE, LOG_VERBOSE,
						"domain '%s': creating keypair", (int)thisdom);
			hfcp = fcpCreateHandle();
			fcpMakeSvkKeypair(hfcp, thissite->ssk_pub, thissite->ssk_priv);
			fcpDestroyHandle(hfcp);

			pLog->Write(LOG_VERBOSE, LOG_VERBOSE,
						"site '%s': pubkey='%s'",
						(int)thisdom,
						(int)thissite->ssk_pub);
			pLog->Write(LOG_VERBOSE, LOG_VERBOSE,
						"site '%s': privkeykey='%s'",
						(int)thisdom,
						(int)thissite->ssk_priv);

			// create job to insert DBR update point
			item.site = thissite;
			svkjob = pSyncQueue->AddItem(sskjob, INSERTQ_TYPE_SVKROOT, item);

		}		// 'if (needs_svkroot)'

		/* now write individual file jobs */
		for (thisfile = filelist; thisfile != NULL; thisfile = thisfile->next)
			if (thisfile->needs_update)
			{
				item.file = thisfile;
				pSyncQueue->AddItem(sskjob, INSERTQ_TYPE_CHKFILE, item);
			}

		/* Update the update field */
		strcpy(thissite->dateupdated, pUtil->getgmtdate());

		// upload the site
		pLog->Write(LOG_USER, LOG_USER, "uploading site '%s'", (int)thisdom);
		pLog->Write(LOG_VERBOSE, LOG_USER,
					"TIME ESTIMATE: %s",
					needs_svkroot
						? (int)"3 minutes to several hours or even days, depending on your HTL setting and total size of your site's files"
						: (int)"2 minutes to several hours, depending on your HTL settings and total size of new or changed files...");
//		fcj_uploadDir(pFCJ, thisdom, thissite->ssk_priv, thissite->rootdir);
//		pLog->Write(LOG_USER, LOG_USER, "upload of domain '%s' successful", (int)thisdom);

		// now do the actual upload
		PerformInserts();
		pLog->Write(LOG_USER, LOG_USER, "upload of domain '%s' successful", (int)thisdom);
		thissite->updating = 0;

		// refresh site display
		if (!pDlg->guiDisabled)
			pSiteList->Refresh();

	}			/* 'for (each site)' */

	////PerformInserts();
	pConfig->save();
	return 0;
}		/* 'fpublish_update()' */



/////////////////////////
/////////////////////////


//
// PerformInserts()
//
// Creates a hierarchical job queue of keys to insert, then
// launches syncthreads:: to insert these keys
//

int CSyncSite::PerformInserts()
{
	int		i;
	INSERTQ	*this_job;

	UpdatesInProgress = TRUE;

	/* Initialise process slots */
	for (i = 0; i < MAXCONCURRENTINSERTS; i++)
		pSyncQueue->JobsInProgress[i] = NULL;

	/* loop through dispatching jobs until we're all done */
	for (UpdatesInProgress = 1; UpdatesInProgress;)
	{
		if ((this_job = pSyncQueue->NextFreeJob()) == NULL)
		{
			/* no more waiting jobs - check for running jobs */
			for (i = 0; i < MAXCONCURRENTINSERTS; i++)
			{
				this_job = pSyncQueue->JobsInProgress[i];

				if (this_job != NULL && this_job->status == INSERTQ_STATUS_INPROG)
					/* found a running job */
					break;
			}

			/* did we find a running job? */
			if (i == MAXCONCURRENTINSERTS)
			{
				/* no waiting jobs and no running jobs */
				pSyncQueue->ResetQueue();
				UpdatesInProgress = 0;
			}

			/* still at least 1 running job */
			Sleep(250L);
			continue;
		}

		/* found a job to schedule = try to find a slot */
		for (i = 0; i < MAXCONCURRENTINSERTS; i++)
			if (pSyncQueue->JobsInProgress[i] == NULL
				||
				pSyncQueue->JobsInProgress[i]->status == INSERTQ_STATUS_DONE
			)
				break;

		/* have we got a job slot? */
		if (i < MAXCONCURRENTINSERTS)
		{
			/* we got a slot - add it and launch if */
			pSyncQueue->JobsInProgress[i] = this_job;
			this_job->status = INSERTQ_STATUS_INPROG;

			CSyncThreads *pThread = new CSyncThreads;

			pThread->slot_num = i;
#ifdef SINGLE_THREAD
			pThread->JobThread(i);	// TEMP HACK - bypass thread launching
#else
			pThread->CreateThread(0, 0);
#endif

//			pSyncThreads->SpawnJob(i);
			continue;
		}

		/* waiting jobs, no slots - no choice but to wait */
		Sleep(250L);

		continue;

	}		/* 'while (1)' */

	pLog->Write(LOG_USER, LOG_USER, "All inserts done");
	return 0;

}			/* 'perform_inserts()' */


int CSyncSite::domainIsRegistered(char *domain)
{
	HFCP *hfcp = fcpCreateHandle();
	char buf[256];

	sprintf(buf, "freenet:KSK@freeweb/%s", domain);
	fcpSetHtl(hfcp, pConfig->htl);
	fcpRawMode(hfcp, 1);
	if (fcpGetKeyToMem(hfcp, buf, NULL, NULL) == 0)
		return 1;	// domain is registered
	else
		return 0;	// key not found - domain not previously registered

}			// 'domainIsRegistered()'

