
/*
maindlg.exe - WIN32 application with a dialof for main window
Copyright (C) 2000  Antti Markus (antti@pld.ttu.ee)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

//useful defines
#ifndef __GNUC__
//useful defines
#define STRICT
#define WIN32_LEAN_AND_MEAN
#endif

//standard includes
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

//additional includes
#include "resource.h"
#include "settings.h"
#include "tray.h"


HINSTANCE hMainInstance;
HWND hMainWnd;


static int	old_remote_proxy_use;
static int  old_browser_proxy_port;
static char old_remote_proxy_host[64];
static int  old_remote_proxy_port;
static int	old_fproxy_port;
static int	old_webblock;
static int	old_webblock_default;
static int	old_allowlocalhost;

static int	remote_proxy_use;
static int  browser_proxy_port;
static char remote_proxy_host[64];
static int  remote_proxy_port;
static int	fproxy_port;
static int	webblock;
static int	webblock_default;
static int	allowlocalhost;


BOOL CALLBACK DialogFunc(HWND hdwnd, UINT Msg, WPARAM wParam, LPARAM lParam);

int settings_dialog(HWND hwnd,
					int *pUse,
					int *pBrowsePort,
					char *pRemHost,
					int *pRemPort,
					int *pFproxyPort,
					int *pWebblock,
					int *pWebblockdef,
					int *pAllowLocalhost)
{
	int nRes;

	old_remote_proxy_use = *pUse;
	old_browser_proxy_port = *pBrowsePort;
	strcpy(old_remote_proxy_host, pRemHost);
	old_remote_proxy_port = *pRemPort;
	old_fproxy_port = *pFproxyPort;
	old_webblock = *pWebblock;
	old_webblock_default = *pWebblockdef;
	old_allowlocalhost = *pAllowLocalhost;

	LoadImage(hwnd, MAKEINTRESOURCE(IDI_FREEWEB), IMAGE_ICON,
                        GetSystemMetrics(SM_CXSMICON),
                        GetSystemMetrics(SM_CYSMICON), 0);

	nRes = DialogBox(0, MAKEINTRESOURCE(IDD_FWSETTINGS), hwnd, DialogFunc);

	*pRemHost = '\0';
	*pUse = remote_proxy_use;
	*pBrowsePort = browser_proxy_port;
	strcpy(pRemHost, remote_proxy_host);
	*pRemPort = remote_proxy_port;
	*pFproxyPort = fproxy_port;
	*pWebblock = webblock;
	*pWebblockdef = webblock_default;
	*pAllowLocalhost = allowlocalhost;

	if (browser_proxy_port != old_browser_proxy_port)
	{
		MessageBox(0,
				"Warning:\n"
				"You have changed the port on which FreeWeb agent\n"
				"listens for requests from your browser\n\n"
				"This change won't come into effect, and your\n"
				"browser will malfunction, until you shut down\n"
				"and restart FreeWeb Agent",
			"FreeWeb Agent - Warning", 0);
	}

	return 0;
}


static BOOL CALLBACK DialogFunc(HWND hdwnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
    char pBuf[15];
	double dSrc=atof(pBuf);

  switch(Msg)
  {
    case WM_INITDIALOG:
    {
		// try to set up image
		

		// Fill in fields supplied by caller
		CheckDlgButton(hdwnd, IDC_USE_REM_PROXY, old_remote_proxy_use);
		SetDlgItemInt(hdwnd, IDC_PROXY_PORT_IN, old_browser_proxy_port, FALSE);
		SetDlgItemText(hdwnd, IDC_PROXY_HOST_OUT, old_remote_proxy_host);
		SetDlgItemInt(hdwnd, IDC_PROXY_PORT_OUT, old_remote_proxy_port, FALSE);
		SetDlgItemInt(hdwnd, IDC_FPROXY_PORT, old_fproxy_port, FALSE);
		CheckDlgButton(hdwnd, IDC_WEBBLOCK, old_webblock);
		CheckDlgButton(hdwnd, IDC_WEBBLOCK_DEFAULT, old_webblock_default);
		CheckDlgButton(hdwnd, IDC_WEBBLOCK_ALLOW_LOCALHOST, old_allowlocalhost);

		return TRUE;
    }

    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
	  case IDOK:
		  /* Extract values */
		  browser_proxy_port = GetDlgItemInt(hdwnd, IDC_PROXY_PORT_IN, NULL, FALSE);
		  GetDlgItemText(hdwnd, IDC_PROXY_HOST_OUT, remote_proxy_host, 63);
		  remote_proxy_port = GetDlgItemInt(hdwnd, IDC_PROXY_PORT_OUT, NULL, FALSE);
		  remote_proxy_use = IsDlgButtonChecked(hdwnd, IDC_USE_REM_PROXY);
		  fproxy_port = GetDlgItemInt(hdwnd, IDC_FPROXY_PORT, NULL, FALSE);
		  webblock = IsDlgButtonChecked(hdwnd, IDC_WEBBLOCK);
		  webblock_default = IsDlgButtonChecked(hdwnd, IDC_WEBBLOCK_DEFAULT);
		  allowlocalhost = IsDlgButtonChecked(hdwnd, IDC_WEBBLOCK_ALLOW_LOCALHOST);
          DestroyWindow(hdwnd);
		  return TRUE;

	  case IDCANCEL:
		  browser_proxy_port = old_browser_proxy_port;
		  strcpy(remote_proxy_host, old_remote_proxy_host);
		  remote_proxy_port = old_remote_proxy_port;
		  remote_proxy_use = old_remote_proxy_use;
		  fproxy_port = old_fproxy_port;
		  webblock = old_webblock;
		  webblock_default = old_webblock_default;
		  allowlocalhost = old_allowlocalhost;
          DestroyWindow(hdwnd);
          return TRUE;
      default:
          return FALSE;
      }

    case WM_DESTROY:
      EndDialog(hdwnd, 0);
      return TRUE;
  }
  return FALSE;
}

