// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// sitedir.cpp: implementation of the CSiteDir class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "stdafx.h"
#include "fwpubgui.h"
#include "constants.h"
#include "config.h"
#include "sitedir.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSiteDir::CSiteDir()
{
	numFiles = 0;
}

CSiteDir::~CSiteDir()
{

}


/*
 * site_directory_valid()
 *
 * Routine to validate a directory name given by user
 *
 * Tests if:
 *		1. Directory actually exists and can be read
 *		2. Directory contains a readable index.html
 *		3. Directory is free of spaces
 *
 * Arguments:
 *
 *		dirname		full ascii pathname of directory to check
 *
 * Returns:
 *
 *		1	if directory exists, and contains an index.html file
 *		0	if either of these conditions aren't met
 */

int	CSiteDir::site_directory_valid(char *dirname)
{
	////char buf[256];

//	sprintf(buf, "%s\\index.html", dirname);
//	if (GetFileAttributes(buf) == -1)
//	{
//		return 0;
//	}

	if (strchr(dirname, ' ') != NULL)
	{
		MessageBox(0, "The folder path's name MUST NOT contain spaces",
						"FreeWeb Error: illegal folder name",
						MB_SYSTEMMODAL | MB_ICONEXCLAMATION);
		return 0;
	}

	return 1;

}		/* 'site_directory_valid()' */



SiteFile *CSiteDir::scan_dir(char *dirname)
{
	numFiles = 0;
	return scan_dir_recurse(dirname, NULL);
}


SiteFile *CSiteDir::scan_dir_recurse(char *dirname, SiteFile *curlist)
{
	WIN32_FIND_DATA finddata;
	HANDLE dirhandle;
	SiteFile *filelist_temp;
	SiteFile *filelist;
	DWORD attribs;
	char subpath[256];
	SYSTEMTIME systime;

	filelist = curlist;

	strcpy(subpath, dirname);
	strcat(subpath, "\\*.*");
	dirhandle = FindFirstFile(subpath, &finddata);
	while(FindNextFile(dirhandle, &finddata) != 0)
	{
		/* Skip parent */
		if (!strcmp(finddata.cFileName, ".."))
			continue;

		/* Get attributes */
		strcpy(subpath, dirname);
		strcat(subpath, "\\");
		strcat(subpath, finddata.cFileName);
		attribs = GetFileAttributes(subpath);

		if (attribs & FILE_ATTRIBUTE_DIRECTORY)
		{
			/* directory - recurse into it */
			filelist_temp = scan_dir_recurse(subpath, filelist);
			filelist = filelist_temp;
		}
		else
		{
			/* normal file - append to list */
			filelist_temp = (SiteFile *)malloc(sizeof(SiteFile));
			strcpy(filelist_temp->filename, subpath);
			filelist_temp->next = filelist;
			filelist_temp->chk[0] = '\0';
			filelist = filelist_temp;

			/* Write in mod date/time */
			FileTimeToSystemTime(&finddata.ftLastWriteTime, &systime);
			sprintf(filelist->time_published,
				"%04d%02d%02d%02d%02d%02d",
				systime.wYear,
				systime.wMonth,
				systime.wDay,
				systime.wHour,
				systime.wMinute,
				systime.wSecond);

			/* Flag as needing update - may disprove later */
			filelist->needs_update = 1;

			// update files count
			numFiles++;
		}
	}
	FindClose(dirhandle);

	return filelist;

}


void CSiteDir::destroy_site_list(SiteFile *filelist)
{
	SiteFile *next;

	while (filelist != NULL)
	{
		next = filelist->next;
		free(filelist);
		filelist = next;
	}
}


//
// looks at all the files from a previous directory scan,
// and generates a human-friendly index.html at the top
// level in that directory
//
// Returns: 0 if successful
//			-1 if error
//

int	CSiteDir::generate_index_html(char *domain, char *dir, SiteFile *filelist)
{
	char indexpath[256];
	FILE *fp;
	int offset = strlen(dir) + 1;

	if (filelist == NULL)
		return -1;

	sprintf(indexpath, "%s\\index.html", dir);
	unlink(indexpath);
	if ((fp = fopen(indexpath, "w")) == NULL)
		return -1;

	// write out header
	fprintf(fp,
		"<html>\n"
		"<head>\n"
		"<title>www.%s.free</title>\n"
		"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n"
		"</head>\n"
		"<body bgcolor=\"#E0E0E8\">\n"
		"<blockquote>\n"
		"<hr>"
		"<font face=\"Arial, Helvetica, sans-serif\" color=\"#666600\">\n"
		"<b><font size=\"5\">www.%s.free</font></b></font><br>\n"
		"<font face=\"Arial, Helvetica, sans-serif\" size=2>\n"
		"<i>Secure, anonymous web browsing and publishing brought to you by \n"
		"<a href=\"http://freeweb.sourceforge.net\">FreeWeb</a>. \n"
		"Supporting true freedom of expression on the internet, thanks to \n"
		"<a href=\"http://www.freenetproject.org\">Freenet</a> and its tireless \n"
		"team of dedicated developers. \n"
		"<a href=\"http://free\">Click Here</a> to return to the <a href=\"http://free\">FreeWeb Gateway</a> page.\n"
		"</i></font>\n"
		"<hr><p><font face=\"Arial, Helvetica, sans-serif\">\n",
		domain, domain);

	// write out body - list of files
	while (filelist != NULL)
	{
		char onefile[256];
		char *s;
		char *fname = filelist->filename + offset;

		// change '\' to '/' - friggin' windows! :(
		strcpy(onefile, fname);
		for (s = onefile; *s != '\0'; s++)
			if (*s == '\\')
				*s = '/';

		fprintf(fp, "<a href=\"%s\">%s</a><br>\n", onefile, onefile);
		filelist = filelist->next;
	}
	// write out footer and finish up
	fprintf(fp, 
		"</font></p><hr><p>&nbsp;</p></blockquote>"
		"</body></html>");
	fclose(fp);
	return 0;

}		// 'generate_index_html()'

