// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// sitedir.h: interface for the CSiteDir class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SITEDIR_H__C24BA3FF_98F5_459E_9BA1_41CB603F6937__INCLUDED_)
#define AFX_SITEDIR_H__C24BA3FF_98F5_459E_9BA1_41CB603F6937__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CSiteDir  
{
public:
	CSiteDir();
	virtual	~CSiteDir();

	int			site_directory_valid(char *dirname);
	SiteFile	*scan_dir(char *dirname);
	void		destroy_site_list(SiteFile *filelist);
	int			generate_index_html(char *domain, char *dir, SiteFile *filelist);
	int			numFiles;

private:
	SiteFile *scan_dir_recurse(char *, SiteFile *);	/* guts of scan_dir() */

};

#endif // !defined(AFX_SITEDIR_H__C24BA3FF_98F5_459E_9BA1_41CB603F6937__INCLUDED_)
