// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// sitelist.cpp : implementation file
//

#include "stdafx.h"
#include "constants.h"
#include "sitelist.h"
#include "fwpubgui.h"
#include "fwpubguidlg.h"
#include "config.h"
#include "util.h"
#include "siteprop.h"

#include "freeweb.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CConfig		*pConfig;
extern CUtil		*pUtil;
extern CFwpubguiDlg *pDlg;
extern CSiteProp	*pSiteProp;
extern CSiteList	*pSiteList;


/////////////////////////////////////////////////////////////////////////////
// CSiteList

CSiteList::CSiteList()
{
}

CSiteList::~CSiteList()
{
}


BEGIN_MESSAGE_MAP(CSiteList, CListCtrl)
	//{{AFX_MSG_MAP(CSiteList)
	ON_WM_LBUTTONDBLCLK()
	ON_NOTIFY_REFLECT(LVN_DELETEITEM, OnDeleteitem)
	ON_NOTIFY_REFLECT(NM_RCLICK, OnRclick)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSiteList message handlers



void CSiteList::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	////char *domain;

	// TODO: Add your message handler code here and/or call default
	CListCtrl::OnLButtonDblClk(nFlags, point);

	siteProperties();
	return;

}

void CSiteList::OnDeleteitem(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
//	MessageBox("Deleting item??", "FreeWeb", MB_OK | MB_SYSTEMMODAL);
	*pResult = 0;
}



void CSiteList::OnRclick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	LPNMHDR Control = (LPNMHDR) pNMHDR;		// stay compatable with IE 3.0!
	
//	int nItem = GetSelectionMark();
//	if (nItem < 2 || nItem > GetItemCount() - 1)
//		return;

	int line_no = GetSelectionMark();
	if (line_no < 0)
		return;
    CMenu menu;
    menu.LoadMenu(IDR_SITELIST_POPUP);
    CMenu *pMenu = menu.GetSubMenu(0);
    ASSERT(pMenu != NULL);

    // Display and track the popup menu
    CPoint point;
    GetCursorPos(&point);

	int res = pMenu->TrackPopupMenu( (TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD),
                 point.x, point.y, this);

//	this->Res
//	std::list<ResultGroup>::iterator itGroup;

	char *domain;
	char buf[128];
	char *dotfree;

	switch(res)
	{
	case ID_SITELIST_POPUP_VIEWSITE:
		domain = GetSelectedDomain();
		if (domain == NULL)
			break;
		sprintf(buf, "http://www.%s", domain);
		ShellExecute(pSiteList->m_hWnd, "open", buf, NULL, NULL, SW_SHOW);
		break;

	case ID_SITELIST_POPUP_SYNCHRONIZE:
		domain = GetSelectedDomain();
		if (domain == NULL)
			break;
		if ((dotfree = strrchr(domain, '.')) != NULL && (!strcmp(dotfree, ".free")))
			*dotfree = '\0';
		strcpy(pDlg->selectedSite, domain);
		pDlg->UploadState = SYNCTHREAD_UPLOADING;
		break;

	case ID_SITELIST_POPUP_DELETE:
		domain = GetSelectedDomain();
		if (domain == NULL)
			break;
		sprintf(buf, "Are you sure you want to delete site '%s'?", domain);
		if (MessageBox(buf, PROGNAME, MB_YESNO | MB_SYSTEMMODAL) != IDYES)
			break;
		pConfig->deleteSite(domain);
		Refresh();
		break;

	case ID_SITELIST_POPUP_PROPERTIES:
		siteProperties();
		break;
	}
		
	SetSelectionMark(0);
	SetSelectionMark(-1);
	*pResult = 0;
}


void CSiteList::Refresh()
{
	// Re-loads the configs into the sites list pane
	////int i;
	Site *thissite;

	// Delete existing window contents
	DeleteAllItems();

	/* Write all our sites to the list box */
	for (thissite = pConfig->firstsite; thissite != NULL; thissite = thissite->next)
	{
		char buf[128];
		int nItem;

		strcpy(buf, thissite->domainname);
		strcat(buf, ".free");
		nItem = InsertItem(0, buf);
		SetItemText(
			nItem,
			1,
			thissite->updating == 1
							? "Updating"
							: ((strcmp(pUtil->getgmtdate(), thissite->dateupdated) > 0) ? "Stale" : "Fresh")
							);
		SetItemText(
			nItem,
			2,
			thissite->rootdir
			);
		SetItemText(
			nItem,
			3,
			thissite->description
			);
	}
}


char * CSiteList::GetSelectedDomain()
{
	int thissite = GetSelectionMark();
	static char buf[90];

	if (thissite < 0)
		return NULL;
	else
	{
		GetItemText(thissite, 0, buf, 90);
		return buf;
	}
}


void CSiteList::FormatWindow()
{
	// Format the window
	// Enable full row highlighting
 	SendMessage(LVM_SETEXTENDEDLISTVIEWSTYLE, 0, LVS_EX_FULLROWSELECT);
 
 	/* Create the columns in the sites list box */
 	InsertColumn(	// Ask Mfc to create/insert a column
 		0,		// This is the rank/order of this 
 				//		particular item
 		"Domain",		// The caption we want for this header
 		LVCFMT_LEFT,	// The relative position we want the 
				// items under this header to have
 		90);		// The width we want for the items under 
 				// this header
 	InsertColumn(1, "Status", LVCFMT_LEFT, 64);
	InsertColumn(2, "Folder", LVCFMT_LEFT, 200);
	InsertColumn(3, "Description", LVCFMT_LEFT, 200);
 
 	// TODO: Add your specialized creation code here
	return;
}

void CSiteList::siteProperties()
{
	char *domain = GetSelectedDomain();
	if (domain == NULL)
		return;
	pSiteProp->edit(domain);
	Refresh();

}
