// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// syncsite.h: interface for the CSyncSite class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SYNCSITE_H__30C0AF85_4884_4347_B2BA_63766931707B__INCLUDED_)
#define AFX_SYNCSITE_H__30C0AF85_4884_4347_B2BA_63766931707B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CSyncSite   : public CWinThread
{
public:
	BOOL InitInstance();
	int UploadAll();
	int UploadSite(char *domain);
	CSyncSite();
	virtual ~CSyncSite();

private:
	int UploadSite_old(char *domain);
	int PerformInserts();
	char UpdatesInProgress;
	int domainIsRegistered(char *domain);
};



#define INSERTQ_TYPE_SVKROOT	'V'
#define INSERTQ_TYPE_KSKPTR		'K'
#define INSERTQ_TYPE_CHKFILE	'F'
#define INSERTQ_TYPE_SSKMAP		'M'

#define INSERTQ_STATUS_WAITING	'W'
#define INSERTQ_STATUS_INPROG	'I'
#define INSERTQ_STATUS_DONE		'D'


#endif // !defined(AFX_SYNCSITE_H__30C0AF85_4884_4347_B2BA_63766931707B__INCLUDED_)
