// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// syncthreads.h: interface for the CSyncThreads class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SYNCTHREADS_H__9B96D865_AEFB_4273_AC2A_1C1B5A91E2DA__INCLUDED_)
#define AFX_SYNCTHREADS_H__9B96D865_AEFB_4273_AC2A_1C1B5A91E2DA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


struct 	mimetab_ent
{
	char *ext;
	char *mimetype;
};



class CSyncThreads : public CWinThread
{
public:
	CSyncThreads();

	static void CSyncThreadChk(SiteFile *file); // for CHK inserts
	static void CSyncThreadDbr(char *domain, char *pub, char *priv);			// for DBR root inserts
	static void CSyncThreadKsk(char *domain, char *pub);		// for KSK ptr inserts
	static void CSyncThreadMsk(char *domain, SiteFile *files, char *rootdir, char *priv);	// for MSK map inserts

	virtual ~CSyncThreads();

	static int NumRunningThreads;		// dangerous global

protected:
	char			JobType;			// helps the thread to know what it's gotta do
	SiteFile		*m_File;			// these fields provide all required info
	char			*m_RootDir;
	char			*m_domain;
	char			*m_pubkey;
	char			*m_privkey;

//	int  PerformInserts();
//	char UpdatesInProgress;
	BOOL			InitInstance();
	int				slot_num;
	int				JobThread(int job_index );		// HACK - needs to be private

private:
	int				JobThreadSvkroot(char *domain, char *svk_pub, char *svk_priv);
	int				JobThreadKskptr(char *domain, char *svk_pub);
	int				JobThreadChkfile(char *pathname, char *chk_key);
	int				JobThreadSskmap(char *domain, char *rootdir, SiteFile *files, char *svk_priv);
	char *			GetMimeType(char *pathname);
	static struct mimetab_ent MimeTab[];
};

#endif // !defined(AFX_SYNCTHREADS_H__9B96D865_AEFB_4273_AC2A_1C1B5A91E2DA__INCLUDED_)
