// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

// util.cpp: implementation of the CUtil class.
//
//////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <shlwapi.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <afxdisp.h>	// OLE stuff
#include <afxpriv.h>	// ANSI to/from Unicode conversion macros

#include "fwpubgui.h"
#include "util.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CUtil::CUtil()
{

}

CUtil::~CUtil()
{

}


char *CUtil::getgmtdate()
{
	time_t timenow;
	struct tm *gmtime_now;
	static char yyyymmdd[9];

	time(&timenow);
	gmtime_now = gmtime(&timenow);

	sprintf(
		yyyymmdd,
		"%04d-%02d-%02d",
		gmtime_now->tm_year + 1900,
		gmtime_now->tm_mon + 1,
		gmtime_now->tm_mday);
	return yyyymmdd;
}

char *CUtil::getgmtdatetime()
{
	time_t timenow;
	struct tm *gmtime_now;
	static char yyyymmddhhmmss[15];

	time(&timenow);
	gmtime_now = gmtime(&timenow);

	sprintf(
		yyyymmddhhmmss,
		"%04d-%02d-%02d %02d:%02d:%02d",
		gmtime_now->tm_year + 1900,
		gmtime_now->tm_mon + 1,
		gmtime_now->tm_mday,
		gmtime_now->tm_hour,
		gmtime_now->tm_min,
		gmtime_now->tm_sec);
	return yyyymmddhhmmss;
}


char *CUtil::getgmtmidnight()
{
	time_t timenow;
	struct tm *gmtime_now;
	static char yyyymmddhhmmss[15];

	time(&timenow);
	gmtime_now = gmtime(&timenow);

	sprintf(
		yyyymmddhhmmss,
		"%04d%02d%02d000000",
		gmtime_now->tm_year + 1900,
		gmtime_now->tm_mon + 1,
		gmtime_now->tm_mday);
	return yyyymmddhhmmss;
}



/* strsav() takes a pointer to a string stored in a dynamically allocated
 * buffer and a pointer to a string and returns a pointer to a new dynamically
 * allocated space that contains the concatenation of the two input strings
 * the previous space is free()'d by realloc().
 */

char *CUtil::strsav(char *old, char *text_to_append)
{
	int old_len, new_len;
	char *p;

	if(( text_to_append == NULL) || (*text_to_append == '\0')) {
		return(old);
	}

	if(old) {
		old_len = strlen(old);
	} else {
		old_len = 0;
	}

	new_len = old_len + strlen(text_to_append) + 1;

	if(old) {
		if((p = (char *)realloc(old, new_len)) == NULL) {
//			fprintf(logfp, "%s: realloc(%d) bytes for proxy_args failed!\n", prog, new_len);
			printf("realloc(%d) bytes for proxy_args failed!\n", new_len);
			exit(1);
		}
	} else {
		if((p = (char *)malloc(new_len)) == NULL) {
//			fprintf(logfp, "%s: malloc(%d) bytes for proxy_args failed!\n", prog, new_len);
			printf("malloc(%d) bytes for proxy_args failed!\n", new_len);
			exit(1);
		}
	}

	strcpy(p + old_len, text_to_append);
	return(p);
}


CString CUtil::ExpandShortcut(CString& csFilename) const
{
	USES_CONVERSION;		// For T2COLE() below
	CString csExpandedFile;

	//
    // Make sure we have a path
	//
	if(csFilename.IsEmpty())
	{
		ASSERT(FALSE);
		return csExpandedFile;
	}

	//
    // Get a pointer to the IShellLink interface
	//
    HRESULT hr;
    IShellLink* pIShellLink;

    hr = ::CoCreateInstance(CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER,
							IID_IShellLink, (LPVOID*) &pIShellLink);

    if (SUCCEEDED(hr))
    {

		//
        // Get a pointer to the persist file interface
		//
		IPersistFile* pIPersistFile;
        hr = pIShellLink->QueryInterface(IID_IPersistFile, (LPVOID*) &pIPersistFile);

        if (SUCCEEDED(hr))
        {
			//
            // Load the shortcut and resolve the path
			//
            // IPersistFile::Load() expects a UNICODE string
			// so we're using the T2COLE macro for the conversion
			//
			// For more info, check out MFC Technical note TN059
			// (these macros are also supported in ATL and are
			// so much better than the ::MultiByteToWideChar() family)
			//
            hr = pIPersistFile->Load(T2COLE(csFilename), STGM_READ);
			
			if (SUCCEEDED(hr))
			{
				WIN32_FIND_DATA wfd;
				hr = pIShellLink->GetPath(csExpandedFile.GetBuffer(MAX_PATH),
										  MAX_PATH,
										  &wfd,
										  SLGP_UNCPRIORITY);

				csExpandedFile.ReleaseBuffer(-1);
            }
            pIPersistFile->Release();
        }
        pIShellLink->Release();
    }

    return csExpandedFile;
}

