// 
//  This code is part of FreeWeb - an FCP-based client for Freenet
//
//  Designed and implemented by David McNab, david@rebirthing.co.nz
//  CopyLeft (c) 2001 by David McNab
//
//  The FreeWeb website is at http://freeweb.sourceforge.net
//  The website for Freenet is at http://freenet.sourceforge.net
//
//  This code is distributed under the GNU Public Licence (GPL) version 2.
//  See http://www.gnu.org/ for further details of the GPL.
//

#ifdef WINDOWS
#include "windows.h"
#include "string.h"
#include "stdio.h"
#endif

#include "ezFCPlib.h"

extern void fwproxy_webblock(int enabled);
extern void fwproxy_setdir(char *dir);

#define NULL ((void *)0)

extern void fwproxy(int listenport,
	int extproxyenabled, char *extproxyaddr, int extproxyport,
	int comeback, int singlethread);

main()
{
#ifdef WINDOWS
	char *progpath = strdup(_pgmptr); // 'pgmptr' is a global windows-specific string
	char *exename = strrchr(progpath, '\\'); // point to slash between path and filename

	*exename++ = '\0'; // split the string and point to filename part
#endif

	// must start up the FCP interface library
	if (fcpStartup("127.0.0.1", 8082, 60, 0) != 0)
	{
		printf("Failed to connect to freenet node\n");
		exit(1);
	}

	fwproxy_webblock(0);
#ifdef WINDOWS
	fwproxy_setdir(progpath);
#else
	fwproxy_setdir("/usr/share/fwproxy");
#endif
	fwproxy(8888, 0, NULL, 0, 0, 0);
}


