/*  libfreenet
 *  Copyright 2001 Steven Hazel <sah@thalassocracy.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __FN_PROTOCOL_H__
#define __FN_PROTOCOL_H__

#include <sys/types.h>
#include <arpa/inet.h>

#include <rijndael-api-fst.h>
#include <config.h>

#define FN_TRUE (1 == 1)
#define FN_FALSE (!FN_TRUE)

#ifdef HAVE_DEV_RANDOM
#define FN_RANDOM_FILE "/dev/random"
#endif

/* encryption key length */
#define FN_KEY_BITS 128
#define FN_KEY_BYTES (FN_KEY_BITS/8)

/* diffie-hellman key length */
#define FN_DHK_LEN 128
#define FN_DHK_MPI_LEN (FN_DHK_LEN+2)

#define FN_HASH_BYTES 20

#define FN_VERSION  1.299
#define FN_REVISION 1.65
#define FN_BUILD    1

#define FN_DEFAULT_PORT 19114

#define FN_DH_N "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF"

#define FN_DH_G "2"

#define FN_DH 30
#define FN_DL 4

#define FNS_SUCCESS               1
#define FNS_INVALID_PORT          -1
#define FNS_INVALID_ADDY          -2
#define FNS_CONNECT_FAILED        -3
#define FNS_SOCKET_FAILED         -4
#define FNS_BIND_FAILED           -5
#define FNS_LISTEN_FAILED         -6
#define FNS_ACCEPT_FAILED         -7
#define FNS_WRITE_FAILED          -8
#define FNS_READ_FAILED           -9
#define FNS_MALLOC_FAILED         -10
#define FNS_INVALID_MPINT         -11
#define FNS_INVALID_DHK           -12
#define FNS_MHASH_FAILED          -13
#define FNS_HASH_TOO_SMALL        -14
#define FNS_MAKEKEY_FAILED        -15
#define FNS_CIPHERINIT_FAILED     -16
#define FNS_ENCRYPT_FAILED        -17
#define FNS_INVALID_REPLY         -18
#define FNS_INVALID_VERSION       -19
#define FNS_WRONG_ID              -20
#define FNS_RANDOM_ERROR          -21
#define FNS_OPEN_FAILED           -22
#define FNS_OVERREAD              -23
#define FNS_INVALID_REQUEST       -24
#define FNS_CONNECTION_GONE       -25
#define FNS_EOF                   -26
#define FNS_OVERWRITE             -27
#define FNS_INVALID_DATA          -28
#define FNS_UNEXPECTED_KEY_LENGTH -29
#define FNS_BAD_KEY               -30
#define FNS_ZERO_DATALEN          -31
#define FNS_TIMEOUT               -32
#define FNS_REQUEST_FAILED        -33
#define FNS_UNEXPECTED_MESSAGE    -34
#define FNS_BUFFER_TOO_SMALL      -35
#define FNS_INVALID_ENDTOEND      -36
#define FNS_INVALID_METADATA_LEN  -37
#define FNS_BN_FAILED             -38
#define FNS_DH_FAILED             -39
#define FNS_BAD_CTRL              -40
#define FNS_BAD_HASH              -41
#define FNS_INVALID_URI           -42
#define FNS_UNKNOWN_KEYTYPE       -43
#define FNS_INVALID_SEARCHKEY     -44
#define FNS_INVALID_ENCKEY        -45
#define FNS_DSA_FAILED            -46
#define FNS_INVALID_PRIVATE_KEY   -47
#define FNS_FSEEK_FAILED          -48
#define FNS_DATA_REPLY            -49
#define FNS_SVK_TOO_LARGE         -50
#define FNS_INVALID_SIG           -51
#define FNS_INVALID_PUBKEY        -52
#define FNS_INVALID_E2E           -53

typedef struct {
  int numfields;
  uint64_t uniqueid;
  char type[128];
  char field[128][512];
} freenet_message;


typedef struct {
  int fbpos;
  unsigned char fb[FN_KEY_BYTES];
  rijndael_keyInstance key;
  rijndael_cipherInstance cipher;
} freenet_rijndael_system;

typedef struct {
  int socket;
  freenet_rijndael_system sendsys;
  freenet_rijndael_system recvsys;
  int expect_callback;
} freenet_connection;

int freenet_senddata(freenet_connection *connection, const char *buffer,
                     int len);
int freenet_sendmsg (freenet_connection *connection, freenet_message *message);

int freenet_readdata(freenet_connection *connection, char *buffer, int len);

int freenet_recvmsg (freenet_connection *connection, freenet_message *message);

int freenet_connect (freenet_connection *connection, char *hostaddress,
                     char *service);

int freenet_get_connection (freenet_connection *connection, u_short port);

int freenet_init (void);

#endif /* __FN_PROTOCOL_H__ */
