/*  libfreenet
 *  Copyright 2001 Steven Hazel <sah@thalassocracy.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <malloc.h>
#include <string.h>

#include "protocol.h"

int main (void)
{
  int i, len;
  freenet_connection connection;
  freenet_message message;
  freenet_message reply;
  unsigned char *data;

  freenet_init();

  while (freenet_get_connection(&connection, FN_DEFAULT_PORT + 1) ==
         FNS_SUCCESS) {

    connection.expect_callback = FN_FALSE;

    while (freenet_recvmsg(&connection, &message)==FNS_SUCCESS) {

      if (strcmp(message.type, "InsertRequest")==0) {
        strcpy(reply.type, "InsertReply");
        for (i=0; i<message.numfields; i++) {
          if (strncmp(message.field[i], "UniqueID=", 9)==0) {
            strcpy(reply.field[0], message.field[i]);
          }
        }
        strcpy(reply.field[1], "Depth=0");
        strcpy(reply.field[2], "HopsToLive=21");
        strcpy(reply.field[3], "EndMessage");
        reply.numfields=4;

        freenet_sendmsg(&connection, &reply);
      } else if (strcmp(message.type, "DataInsert")==0) {

        len=-1;

        if (strcmp(message.field[message.numfields-1], "Data")!=0) {
          printf("trailing field on DataInsert is %s\n",
                 message.field[message.numfields-1]);
        }
        for (i=0; i<message.numfields; i++) {
          if (strncmp(message.field[i], "DataLength=", 11)==0) {
            sscanf(message.field[i], "DataLength=%x", &len);
          }
        }

        printf("reading %d bytes\n", len);

        if (len>0) {
          data = malloc(len);
          if (data == NULL) {
            printf("bad malloc\n");
            return -1;
          }

          freenet_readdata(&connection, data, len);

          printf("got:\n");
          for (i=0; i<len; i++) {
            printf("%x ", data[i]);
          }
          printf("\n");

        }

      }

    }


  }


  return 1;
}
