/*  libfreenet
 *  Copyright 2001 Steven Hazel <sah@thalassocracy.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <string.h>

#include "uri.h"
#include "client_util.h"

int freenet_parse_redirect (freenet_key *key, const unsigned char *metadata)
{
  unsigned char *uri;
  int urilen;
  int status;
  int retval;

  uri = NULL;

  if (strncmp(metadata, "Redirect\nEnd\n", 13) != 0) {
    retval = FNS_NOT_A_REDIRECT;
    goto end;
  }

  if (metadata[strlen(metadata) - 1] != '\n') {
    retval = FNS_NOT_A_REDIRECT;
    goto end;
  }

  urilen = strlen(&(metadata[13])) - 1;

  uri = malloc(urilen + 1);
  if (uri == NULL) {
    retval = FNS_MALLOC_FAILED;
    goto end;
  }

  strncpy(uri, &(metadata[13]), urilen);
  uri[urilen] = 0;

  status = freenet_parse_request_uri(key, uri);
  if (status != FNS_SUCCESS) {
    retval = status;
    goto end;
  }

  retval = FNS_SUCCESS;

 end:
  free(uri);
  return retval;
}
