#ifndef __FN_TWOFISH_H__
#define __FN_TWOFISH_H__

#include <sys/types.h>

/* Structure for an expanded Twofish key.  s contains the key-dependent
 * S-boxes composed with the MDS matrix; w contains the eight "whitening"
 * subkeys, K[0] through K[7].  k holds the remaining, "round" subkeys.  Note
 * that k[i] corresponds to what the Twofish paper calls K[i+8]. */
typedef struct {
   u_int32_t s[4][256], w[8], k[32];
} TWOFISH_context;

int twofish_setkey (TWOFISH_context *ctx, const u_int8_t *key,
                    const unsigned keylen);

void twofish_encrypt (const TWOFISH_context *ctx, u_int8_t *out,
                      const u_int8_t *in);

void twofish_decrypt (const TWOFISH_context *ctx, u_int8_t *out,
                      const u_int8_t *in);

#endif /* __FN_TWOFISH_H__ */
