/*  libfreenet
 *  Copyright 2001 Steven Hazel <sah@thalassocracy.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __FN_UTIL_H__
#define __FN_UTIL_H__


int readall(int sock, unsigned char *buffer, int len);

int writeall(int sock, unsigned char *buffer, int len);

int raw_to_bagbiting_freenet_mpi(unsigned char *x, int xlen,
                                 unsigned char *bfmpi);

int keygen (const unsigned char *k, int klen, unsigned char *key,
            int keybytes);

int generate_random(unsigned char *buffer, int len);

#endif /* __FN_UTIL_H__ */
