/*  libfreenet
 *  Copyright 2001 Steven Hazel <sah@thalassocracy.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __FN_ENDTOEND_H__
#define __FN_ENDTOEND_H__

#include "client.h"

__inline__ int endtoend_init (freenet_client_stream *cstream,
                              unsigned char *key);

__inline__ int endtoend_encrypt (freenet_client_stream *cstream,
                                 unsigned char *inbuffer,
                                 unsigned char *outbuffer, int len);

__inline__ int endtoend_decrypt (freenet_client_stream *cstream,
                                 unsigned char *inbuffer,
                                 unsigned char *outbuffer, int len);

#endif /* __FN_ENDTOEND_H__ */
