/*  libfreenet
 *  Copyright 2001 Steven Hazel <sah@thalassocracy.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __FN_STREAM_H__
#define __FN_STREAM_H__

#include <openssl/sha.h>

#define FN_MAX_DOCNAME 512
#define FN_SVK_TYPE 0x0201
#define FN_KSK_TYPE 0x0202
#define FN_CHK_TYPE 0x0301

#define FN_MAX_PARTS 66666

#define FN_CB_OK 0
#define FN_CB_RESTARTED 1

#define FN_INCOMING_STREAM 1
#define FN_OUTGOING_STREAM 2

#define FN_GROUP_A_P "b9850e5e9607d50d000000000000000000000000000000000\
00000002cdc65f1e9a7dccb571627333dd0520bf0deb206d7\
c2937330a7d6e73cec4928b172c7e8ea04cc075d18db1340d\
ac2065cbce69c5ff20b4bca2d89d2932204149a3b6811be27\
458e7d2518edf9bf4417acb1e79243fe6ae1eac68cef6d655\
43c47c1f795"

#define FN_GROUP_A_Q "cfabfbd9fa4661010d9d11d0c381bb574da72667"

#define FN_GROUP_A_G "2668d2935bdd27dad0a1f469c69c6f7e7bd5a3ea73adc6bc0\
a781c0a276993a0cdbb575635423744dd2e2fbd7e962ac5b4\
b79632f030ddef166c53cb002f692e2fd927f17e3e6bd404f\
573207557972c630c01e6cc8b37fb348ad2686f4b4e3e681d\
9ced93cde9f30a2f17380204274141dce60c6151ef1b7acd0\
39ab1227fcd"


#define FN_GROUP_B_P "c9381f278f7312c7fffffffffffffffffffffffffffffffff\
fffffffa8a6d5db1ab21047302cf6076102e67559e1569484\
6e3c7ceb4e18b6c652aedcfb337af057bdc12dcfc452d3ae4\
cfc5c3b7586804d4983bd5370db5512cf313e9a2c9c138c60\
2901135c4cfbcbe92d29fe744831f63e3273908c4f62f2129\
1840350f1e5"

#define FN_GROUP_B_Q "c88fa2a0b1e70ba3876a35140fddce3c683706ad"

#define FN_GROUP_B_G "65d3ccb70df16dc08822be40736bf951383f6c03ddfd51c1a\
41627fafb2b7f74a1e65ade0ab9f7c189c497cfb6fe6e9e7b\
a4160d7fd15bae68bff0e4a96f412e85924bcc89fee431406\
13afd124f425f891a2d3022f0a0444692e510fc5310360a21\
e3f729ab93f2ad81b0bbe27d86bc65cf385036969ede2473e\
6017df36d12"


typedef struct {
  char p[1024];
  char q[1024];
  char g[1024];
} freenet_group;

typedef struct {
  int type;
  unsigned char searchkey[FN_HASH_BYTES + 3];
  unsigned char enckey[FN_KEY_BYTES];
  unsigned char pub[FN_DHK_LEN];
  unsigned char priv[FN_HASH_BYTES];
  unsigned char docname[FN_MAX_DOCNAME];
  freenet_group group;
} freenet_key;

typedef struct {
  freenet_connection connection;

  int direction;

  int size;
  int pos;
  int partsize;
  int current_part;
  int last_part;
  int contentpos;
  unsigned char hash[FN_MAX_PARTS][FN_HASH_BYTES];

  /* incoming only */
  SHA_CTX hash_handle;
  int keytype;
  int payload_len;
  unsigned char pub[FN_DHK_LEN];
  unsigned char sigstr[(FN_DHK_LEN*2) +2]; //comma and null term
  freenet_group group;

} freenet_stream;

int freenet_read_stream(freenet_stream *stream,
                        unsigned char *buffer, int len);

int freenet_write_stream(freenet_stream *stream,
                         unsigned char *buffer, int len);

int freenet_init_incoming_stream (freenet_stream *stream,
                                  freenet_key *key, freenet_message *message);

int freenet_init_outgoing_stream (freenet_stream *stream);

#endif /* __FN_STREAM_H__ */
