/*  libfreenet
 *  Copyright 2001 Steven Hazel <sah@thalassocracy.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <malloc.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/socket.h>


#include "protocol.h"
#include "stream.h"

int main (void)
{
  struct sockaddr_in address;
  int listening_socket;
  int connected_socket;
  int reuse_addr = 1;
  struct sockaddr_in incoming;
  int b;
  u_short port = FN_DEFAULT_PORT + 1;
  int status, i, j;
  char in;
  freenet_message message;
  freenet_message reply;
  freenet_key key;
  freenet_stream stream;
  char skstr[((FN_HASH_BYTES+3)*2) + 1];
  char tmp[3];

  stream.connection.timeout = 0;
  stream.connection.expect_callback = FN_FALSE;

  /* Setup internet address information.
     This is used with the bind() call */
  memset((char *) &address, 0, sizeof(address));
  address.sin_family = AF_INET;
  address.sin_port = htons(port);
  address.sin_addr.s_addr = htonl(INADDR_ANY);

  listening_socket = socket(AF_INET, SOCK_STREAM, 0);
  if (listening_socket < 0) {
    return FNS_SOCKET_FAILED;
  }

  setsockopt(listening_socket, SOL_SOCKET, SO_REUSEADDR, (char *)&reuse_addr,
    sizeof(reuse_addr));

  if (bind(listening_socket, (struct sockaddr *)&address,
    sizeof(address)) < 0) {
    close(listening_socket);
    return FNS_BIND_FAILED;
  }

  if (listen(listening_socket, 1) < 0) {
    return FNS_LISTEN_FAILED;
  }

  do {
    connected_socket = -1;
    while(connected_socket < 0) {
      b = sizeof(incoming);
      connected_socket = accept(listening_socket, &incoming, &b);

    }


    if (FN_FALSE) {
      close(listening_socket); /* Close this socket */
    }

  } while (fork() != 0);

  stream.connection.socket = connected_socket;

  if (freenet_auth_connection(&(stream.connection)) == FNS_SUCCESS) {

    stream.connection.expect_callback = FN_FALSE;

    status = freenet_recvmsg(&(stream.connection), &message);
    while (status == FNS_SUCCESS) {

      if (message.type == FN_INSERTREQUEST_MSG) {
        for (i=0; i<message.numfields; i++) {
          if (strncmp(message.field[i], "SearchKey=", 10)==0) {
            printf("found: %s\n", message.field[i]);
            strncpy(skstr, &(message.field[i][10]), (FN_HASH_BYTES+3) * 2);
            skstr[((FN_HASH_BYTES+3)*2) + 1] = 0;
            for (j = 0; j < strlen(skstr) / 2; j++) {
              strncpy(tmp, &(skstr[j*2]), 2);
              tmp[2] = 0;
              key.searchkey[j] = (unsigned char)strtol(tmp, NULL, 16);
              printf("%d\n", key.searchkey[j]);
            }
          }
        }

        reply.type = FN_INSERTREPLY_MSG;
        reply.uniqueid = message.uniqueid;
        strcpy(reply.field[0], "Depth=0");
        strcpy(reply.field[1], "HopsToLive=21");
        reply.numfields=2;

        freenet_sendmsg(&(stream.connection), &reply);
      } else if (message.type == FN_DATAINSERT_MSG) {

        key.type = htons(*((u_int16_t *)&(key.searchkey[FN_HASH_BYTES+1])));

        printf("key type = %.4x\n", key.type);

        if (key.type == FN_KSK_TYPE) {
          strcpy(key.group.p, FN_GROUP_A_P);
          strcpy(key.group.q, FN_GROUP_A_Q);
          strcpy(key.group.g, FN_GROUP_A_G);
        } else if (key.type == FN_SVK_TYPE) {
          strcpy(key.group.p, FN_GROUP_B_P);
          strcpy(key.group.q, FN_GROUP_B_Q);
          strcpy(key.group.g, FN_GROUP_B_G);
        }

        status = freenet_init_incoming_stream(&stream, &key, &message);
        if (status != FNS_SUCCESS) {
          fprintf(stderr, "freenet_init_incoming_stream died with status %d\n",
                  status);
          return 1;
        }

        for (i = 0; i < stream.payload_len; i++) {

          status = freenet_read_stream(&stream, &in, 1);
          if (status != FNS_SUCCESS) {
            fprintf(stderr, "freenet_read_raw_stream died with status %d\n",
                    status);
            return 1;
          }

          /* printf("%d / %d: %d\n", i, stream.payload_len, in);*/

        }
        printf("\n");

      }

      status = freenet_recvmsg(&(stream.connection), &message);
    }

    printf("freenet_recvmsg died with status %d\n", status);


  }


  return 1;
}
