/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.cli;

import Freenet.Address;
import Freenet.BadAddressException;
import Freenet.Params;
import Freenet.client.ClientCore;
import Freenet.client.ClientFactory;
import Freenet.client.ClientUtil;
import Freenet.client.FCPClient;
import Freenet.client.FNPClient;
import Freenet.support.Logger;
import Freenet.support.StandardLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import relentless.gj.cli.ManifestFileRecord;
import relentless.gj.client.batch.BatchBase;

class CLIBase {
    static final String FILE_CONFIG = "mftools.ini";
    ClientCore cc = null;
    Address target = null;
    int htl = -1;
    ClientFactory clientFactory = null;
    int defaultRetries = 2;
    int retryHtlIncrement = 5;

    CLIBase(Params params) throws IOException {
        String string = params.getParam("logging", "NORMAL");
        int n = StandardLogger.priorityOf((String)string);
        int n2 = params.getint("verbosity", StandardLogger.SPARSE);
        String string2 = params.getParam("logFile", "no");
        StandardLogger standardLogger = null;
        standardLogger = string2.equals("no") ? new StandardLogger(System.err, n2, n) : new StandardLogger((OutputStream)new FileOutputStream(string2), n2, n);
        int n3 = params.getint("listenPort", 0);
        String string3 = null;
        boolean bl = params.getboolean("useFCP", false);
        if (bl) {
            string3 = params.getParam("serverAddress", "tcp/127.0.0.1:8082");
            System.err.println("Using FCP connection to: " + string3);
        } else {
            string3 = params.getParam("serverAddress", "tcp/127.0.0.1:19114");
            System.err.println("Using FNP connection to: " + string3);
        }
        this.htl = params.getint("htl", 15);
        this.defaultRetries = params.getint("retries", 2);
        this.retryHtlIncrement = params.getint("retryHtlIncrement", 5);
        try {
            if (!bl) {
                this.cc = ClientUtil.getTCPCore((int)n3, (Params)params, (Logger)standardLogger);
            }
            this.target = ClientUtil.getAddress((String)string3);
        }
        catch (BadAddressException badAddressException) {
            throw new IllegalArgumentException("Could not parse address `" + string3 + "'.  It should be " + "<host>:<port> or tcp/<host>:<port>");
        }
        catch (BindException bindException) {
            throw new IllegalArgumentException("Could not bind to port " + n3 + ".  (Remember, users " + "only have access to ports >1024 on most systems.)");
        }
        this.clientFactory = bl ? new FCPClient(this.target) : new FNPClient(this.cc, this.target);
    }

    public synchronized void release() throws IOException {
        if (this.cc != null) {
            this.cc.listen = false;
            this.cc.listener.close();
            this.cc = null;
        }
    }

    public static void removeTmpDir() throws IOException {
        BatchBase.removeTmpDir();
    }

    public static void createTmpDir(String string) throws IOException {
        BatchBase.createTmpDir(string);
    }

    static File findConfigFile(String string) {
        File file;
        if (string == null) {
            return null;
        }
        String string2 = System.getProperty("user.home");
        if (string2 != null && (file = new File(string2, string)).exists() && file.isFile() && file.length() > 0L) {
            return file;
        }
        string2 = System.getProperty("user.dir");
        if (string2 != null && (file = new File(string2, string)).exists() && file.isFile() && file.length() > 0L) {
            return file;
        }
        return null;
    }

    static Params getParams(String string, String[] stringArray) throws IOException {
        File file = CLIBase.findConfigFile(string);
        if (file != null) {
            System.err.println("Reading config file: " + file.getAbsolutePath());
            return new Params(file.getAbsolutePath(), stringArray);
        }
        return new Params(stringArray);
    }

    class InfoBase {
        private int htl = -1;
        private int tries = -1;
        private ManifestFileRecord record = null;
        private boolean succeeded = false;

        protected InfoBase(ManifestFileRecord manifestFileRecord, int n, int n2) {
            this.record = manifestFileRecord;
            this.htl = n;
            this.tries = n2;
            this.succeeded = false;
        }

        public final int getHtl() {
            return this.htl;
        }

        public final void setHtl(int n) {
            this.htl = n;
        }

        public final int getRetries() {
            return this.tries;
        }

        public final void setRetries(int n) {
            this.tries = n;
        }

        public final ManifestFileRecord getRecord() {
            return this.record;
        }

        public final boolean getSucceeded() {
            return this.succeeded;
        }

        public final void setSucceeded(boolean bl) {
            this.succeeded = bl;
        }
    }
}

