/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.client;

import Freenet.FieldSet;
import Freenet.Params;
import Freenet.client.ClientEvent;
import Freenet.client.ClientEventListener;
import Freenet.client.ClientFactory;
import Freenet.client.ClientKey;
import Freenet.client.ClientUtil;
import Freenet.client.DataRequest;
import Freenet.client.FreenetURI;
import Freenet.client.Request;
import Freenet.client.events.ErrorEvent;
import Freenet.client.events.ExceptionEvent;
import Freenet.client.events.NoReplyEvent;
import Freenet.client.events.RequestCompleteEvent;
import Freenet.client.events.RequestFailedEvent;
import Freenet.client.events.RestartedEvent;
import Freenet.client.events.SegmentCompleteEvent;
import Freenet.client.events.StateReachedEvent;
import Freenet.client.events.TransferStartedEvent;
import Freenet.client.events.TransferedEvent;
import Freenet.support.Bucket;
import Freenet.support.FileBucket;
import Freenet.support.io.ReadInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.EventListener;
import java.util.EventObject;
import relentless.gj.client.RequestSlaveListener;
import relentless.gj.client.RequestStatusEvent;
import relentless.gj.client.SlaveBase;
import relentless.gj.client.SlaveRestartedEvent;
import relentless.gj.util.EventDispatcher;
import relentless.gj.util.EventFirer;

public class RequestSlave
extends SlaveBase {
    public static final int MAX_REDIRECTS = 25;
    public static final int WAITING_FOR_TRANSFER = 10;
    public static final int WAITING_FOR_META_DATA = 11;
    public static final int WAITING_FOR_DATA = 12;
    public static final int WAITING_FOR_TRANSFER_COMPLETE = 13;
    public static final int REQUEST_COMPLETING = 14;
    public static final int REQUEST_COMPLETE = 15;
    public static final int REQUEST_FAILING = 16;
    public static final int REQUEST_FAILED = 17;
    public static final int REQUEST_REDIRECTED = 18;
    private String originalURI = null;
    private String redirectCHK = null;
    private String fileName = null;
    private boolean overwrite = true;
    private String currentURI = null;
    private ClientKey currentKey = null;
    private FreenetURI haltCHK = null;
    private boolean skippedDownload = false;
    private String mimeType = null;
    private Bucket dataOut = null;
    private Bucket metaDataOut = null;
    private long totalLength = 0L;
    private long dataLength = 0L;
    private long metaDataLength = 0L;
    private long bytesTransferred = 0L;
    private long transferStartTimeMs = -1L;
    private int bytesPerSecond = -1;
    private long maxCombinedDataLength = 0L;
    private boolean maxCombinedDataLengthExceeded = false;
    private boolean abortAfterFinalRedirect = false;
    private boolean sawData = false;
    private boolean autoRedirect = true;
    private int nRedirects = 0;

    public final synchronized int getExitStatus() {
        switch (this.state) {
            case 15: {
                return 2;
            }
            case 17: {
                return 3;
            }
        }
        return 1;
    }

    public void abort() {
        throw new RuntimeException("RequestSlave.abort -- NOT IMPLEMENTED. Sorry :(");
    }

    public RequestSlave(ClientFactory clientFactory, Params params) {
        super(clientFactory, params);
        this.clientEventListener = new RequestClientEventListenerImpl();
        this.task = new RequestRunnableImpl();
        this.dispatcher = new EventDispatcher(new EventFirerImpl());
        this.state = 15;
    }

    public synchronized void startRequest(String string, int n, String string2, Object object) throws MalformedURLException {
        if (string2 == null) {
            throw new IllegalArgumentException("outputFileName == null");
        }
        this.startRequest(string, null, null, null, string2, n, object);
    }

    public synchronized void startRequest(String string, int n, Bucket bucket, Bucket bucket2, Object object) throws MalformedURLException {
        this.startRequest(string, null, bucket, bucket2, null, n, object);
    }

    public synchronized void startRedirectCheck(String string, String string2, int n, Object object) throws MalformedURLException {
        this.startRequest(string, string2, null, null, null, n, object);
    }

    public final String getURI() {
        return this.originalURI;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getRedirectCHK() {
        return this.redirectCHK;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final void setAutoRedirect(boolean bl) {
        this.autoRedirect = bl;
    }

    public final void setMaxBytes(long l) {
        this.maxCombinedDataLength = l;
    }

    public final boolean getMaxBytesExceeded() {
        return this.maxCombinedDataLengthExceeded;
    }

    public final void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public final void setAbortAfterFinalRedirect(boolean bl) {
        this.abortAfterFinalRedirect = bl;
    }

    public final void addRequestSlaveListener(RequestSlaveListener requestSlaveListener) {
        this.dispatcher.addListener(requestSlaveListener);
    }

    public final void removeRequestSlaveListener(RequestSlaveListener requestSlaveListener) {
        this.dispatcher.removeListener(requestSlaveListener);
    }

    public static final String stateToString(int n) {
        switch (n) {
            case 10: {
                return "WAITING_FOR_TRANSFER";
            }
            case 11: {
                return "WAITING_FOR_META_DATA";
            }
            case 12: {
                return "WAITING_FOR_DATA";
            }
            case 13: {
                return "WAITING_FOR_TRANSFER_COMPLETE";
            }
            case 14: {
                return "REQUEST_COMPLETING";
            }
            case 15: {
                return "REQUEST_COMPLETE";
            }
            case 16: {
                return "REQUEST_FAILING";
            }
            case 17: {
                return "REQUEST_FAILED";
            }
            case 18: {
                return "REQUEST_REDIRECTED";
            }
        }
        return "UNKNOWN_STATE: " + n;
    }

    synchronized EventObject makeStatusEvent() {
        return new RequestStatusEvent(this, this.state, this.getExitStatus(), this.dataLength + this.metaDataLength, this.bytesTransferred, this.bytesPerSecond, this.extraData);
    }

    void startRequest(String string, String string2, Bucket bucket, Bucket bucket2, String string3, int n, Object object) throws MalformedURLException {
        RequestSlave requestSlave = this;
        synchronized (requestSlave) {
            if (this.slaveThread != null) {
                throw new RuntimeException("RequestSlave.startRequest(0) -- Still processing previous request!");
            }
            try {
                this.slaveThread = new Thread(this.task, "RequestSlave task:" + string);
                this.extraData = object;
                this.htl = n;
                this.dataOut = bucket;
                this.metaDataOut = bucket2;
                this.currentURI = string;
                this.originalURI = string;
                if (ClientUtil.isMSK((String)this.currentURI)) {
                    this.currentURI = ClientUtil.lookupMSK((String)string, (Params)this.params);
                }
                this.haltCHK = null;
                this.skippedDownload = false;
                if (string2 != null) {
                    this.haltCHK = new FreenetURI(string2);
                    if (!this.haltCHK.getKeyType().equals("CHK")) {
                        throw new IllegalArgumentException("Non-CHK values not allowed for redirectCHKURI.");
                    }
                    this.skippedDownload = true;
                    this.abortAfterFinalRedirect = true;
                }
                this.fileName = string3;
                this.exceptions.removeAllElements();
                this.dataLength = 0L;
                this.totalLength = 0L;
                this.maxCombinedDataLengthExceeded = false;
                this.bytesTransferred = 0L;
                this.transferStartTimeMs = -1L;
                this.bytesPerSecond = -1;
                this.metaDataLength = 0L;
                this.clientLibraryFinished = false;
                this.nRedirects = 0;
                this.currentKey = ClientUtil.getKeyFromURI((FreenetURI)new FreenetURI(this.currentURI));
                this.data = new FileBucket(SlaveBase.makeTempFile());
                this.metaData = new FileBucket(SlaveBase.makeTempFile());
                this.sawData = false;
                this.mimeType = null;
                this.state = 10;
            }
            catch (MalformedURLException malformedURLException) {
                this.slaveThread = null;
                this.setState(17);
                throw malformedURLException;
            }
            catch (RuntimeException runtimeException) {
                this.slaveThread = null;
                this.setState(17);
                throw runtimeException;
            }
        }
        this.slaveThread.start();
    }

    /*
     * Unable to fully structure code
     */
    private DataRequest getRedirect() throws IOException {
        block16: {
            block13: {
                ++this.nRedirects;
                this.currentURI = null;
                this.currentKey = null;
                var1_1 = null;
                var1_1 = new ReadInputStream(this.metaData.getInputStream());
                var2_2 = var1_1.readTo('\n', '\r');
                var3_3 = false;
                if (!var2_2.equals("Redirect")) break block14;
                var4_4 = new FieldSet();
                var4_4.parseFields(var1_1);
                var5_6 = new FreenetURI(var1_1.readTo('\n', '\r'));
                var6_7 = var4_4.get("baseline");
                var7_8 = var4_4.get("increment");
                if (var6_7 != null && var7_8 != null) {
                    var5_6 = ClientUtil.dateURI((FreenetURI)var5_6, (String)var6_7, (String)var7_8);
                }
                var3_3 = var5_6.getKeyType().equals("CHK");
                this.currentURI = var5_6.toString();
                if (!var3_3) break block15;
                this.redirectCHK = this.currentURI;
                if (this.haltCHK == null || !this.haltCHK.equals(this.currentKey)) break block13;
                var1_1.close();
                var1_1 = null;
                this.fire(this.setState(14));
                var8_9 = null;
                var10_10 = null;
                ** if (var1_1 == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        var1_1.close();
                    }
                    catch (IOException var11_14) {
                        // empty catch block
                    }
                }
lbl-1000:
                // 3 sources

                {
                    block14: {
                        block15: {
                            return var8_9;
                        }
                        this.redirectCHK = null;
                        break block13;
                    }
                    if (!var2_2.equals("Mapfile")) break block13;
                    var1_1.close();
                    var1_1 = null;
                    this.fire(this.setState(14));
                    var4_5 = null;
                }
                var10_11 = null;
                if (var1_1 == null) ** GOTO lbl53
                try {
                    var1_1.close();
                }
                catch (IOException var11_15) {
                    // empty catch block
                }
lbl53:
                // 3 sources

                return var4_5;
            }
            var10_12 = null;
            if (var1_1 != null) {
                try {
                    var1_1.close();
                }
                catch (IOException var11_16) {}
            }
            break block16;
            catch (Throwable var9_18) {
                var10_13 = null;
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                    }
                    catch (IOException var11_17) {
                        // empty catch block
                    }
                }
                throw var9_18;
            }
        }
        if (this.currentURI == null) {
            return null;
        }
        this.currentKey = ClientUtil.getKeyFromURI((FreenetURI)new FreenetURI(this.currentURI));
        if (this.currentKey == null) {
            return null;
        }
        this.data.resetWrite();
        this.metaData.resetWrite();
        this.exceptions.removeAllElements();
        this.dataLength = 0L;
        this.totalLength = 0L;
        this.maxCombinedDataLengthExceeded = false;
        this.bytesTransferred = 0L;
        this.transferStartTimeMs = -1L;
        this.bytesPerSecond = -1;
        this.metaDataLength = 0L;
        this.clientLibraryFinished = false;
        this.sawData = false;
        this.mimeType = null;
        return new DataRequest(this.htl, this.currentKey.getURI(), this.metaData, this.data);
    }

    private void performRequest(Request request) throws IOException {
        RequestSlave requestSlave = this;
        synchronized (requestSlave) {
            this.state = 10;
        }
        this.clientFactory.obtainClient(request).execute();
        RequestSlave requestSlave2 = this;
        synchronized (requestSlave2) {
            while (this.state != 14 && this.state != 16 && this.state != 18) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private final synchronized void handleStateReachedEvent(StateReachedEvent stateReachedEvent) {
        int n = stateReachedEvent.getState();
        if (n == 4 || n == -1) {
            this.clientLibraryFinished = true;
            this.notifyAll();
        }
    }

    private final void handleTransferStartedEvent(TransferStartedEvent transferStartedEvent) {
        EventObject eventObject = null;
        RequestSlave requestSlave = this;
        synchronized (requestSlave) {
            this.dataLength = transferStartedEvent.getDataLength();
            this.metaDataLength = transferStartedEvent.getMetadataLength();
            this.totalLength = transferStartedEvent.getLength();
            if (this.maxCombinedDataLength > 0L && this.totalLength > this.maxCombinedDataLength) {
                this.maxCombinedDataLengthExceeded = true;
                throw new RuntimeException("Aborting request: maxCombinedDataLength exceeded! (HACK)");
            }
            this.transferStartTimeMs = System.currentTimeMillis();
            if (this.dataLength == 0L && this.metaDataLength == 0L) {
                System.err.println("RequestSlave.handleTransferStartedEvent -- failing!");
                eventObject = this.setState(16);
            } else if (this.metaDataLength > 0L) {
                eventObject = this.setState(11);
            } else {
                if (this.abortAfterFinalRedirect) {
                    this.sawData = true;
                    throw new RuntimeException("Aborting request: forgive me for this hack!");
                }
                this.bytesPerSecond = 0;
                eventObject = this.setState(13);
            }
        }
        this.fire(eventObject);
    }

    private final void handleTransferedEvent(TransferedEvent transferedEvent) {
        EventObject eventObject = null;
        RequestSlave requestSlave = this;
        synchronized (requestSlave) {
            this.bytesTransferred = transferedEvent.getProgress();
            if (this.state == 13) {
                long l = System.currentTimeMillis();
                if (l > this.transferStartTimeMs) {
                    this.bytesPerSecond = (int)(this.bytesTransferred * 1000L / (l - this.transferStartTimeMs));
                } else {
                    long l2 = l + (Long.MAX_VALUE - this.transferStartTimeMs) + 1L;
                    this.bytesPerSecond = (int)(this.bytesTransferred * 1000L / l2);
                }
                eventObject = this.makeStatusEvent();
            }
        }
        this.fire(eventObject);
    }

    private final void handleSegmentCompleteEvent(SegmentCompleteEvent segmentCompleteEvent) {
        EventObject eventObject = null;
        RequestSlave requestSlave = this;
        synchronized (requestSlave) {
            if (this.state == 11) {
                if (this.dataLength == 0L) {
                    eventObject = this.setState(18);
                } else {
                    this.mimeType = null;
                    InputStream inputStream = null;
                    try {
                        inputStream = this.metaData.getInputStream();
                        if (inputStream != null) {
                            FieldSet fieldSet = new FieldSet(new ReadInputStream(inputStream));
                            this.mimeType = fieldSet.get("Content-Type");
                            inputStream.close();
                            inputStream = null;
                        }
                        if (this.abortAfterFinalRedirect) {
                            this.sawData = true;
                            throw new RuntimeException("Aborting request: forgive me for this hack!");
                        }
                        this.bytesPerSecond = 0;
                        eventObject = this.setState(13);
                    }
                    catch (IOException iOException) {
                        this.exceptions.push(iOException);
                        System.err.println("RequestSlave.handleSegmentCompleteEvent -- failing! ioexception");
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                        }
                        eventObject = this.setState(16);
                    }
                }
            } else if (this.state != 18 && this.state != 13) {
                System.err.println("RequestSlave.handleSegmentCompleteEvent -- failing! assertion failure: " + RequestSlave.stateToString(this.state));
                eventObject = this.setState(16);
            }
        }
        this.fire(eventObject);
    }

    private final void handleRestartedEvent(RestartedEvent restartedEvent) {
        SlaveRestartedEvent slaveRestartedEvent = null;
        RequestSlave requestSlave = this;
        synchronized (requestSlave) {
            slaveRestartedEvent = new SlaveRestartedEvent(this, restartedEvent, this.extraData);
        }
        this.fire(slaveRestartedEvent);
    }

    private final void handleRequestCompleteEvent(RequestCompleteEvent requestCompleteEvent) {
        EventObject eventObject = null;
        RequestSlave requestSlave = this;
        synchronized (requestSlave) {
            if (this.state == 13) {
                eventObject = this.setState(14);
            } else if (this.state != 18) {
                System.err.println("RequestSlave.handleRequestCompleteEvent -- failing! assertion failure");
                eventObject = this.setState(16);
            }
        }
        this.fire(eventObject);
    }

    private final void handleNoReplyEvent(NoReplyEvent noReplyEvent) {
        System.err.println("RequestSlave.handleNoReplyEvent -- failing!");
        this.fire(this.setState(16));
    }

    private final void handleRequestFailedEvent(RequestFailedEvent requestFailedEvent) {
        this.fire(this.setState(16));
    }

    private final void handleErrorEvent(ErrorEvent errorEvent) {
        this.fire(this.setState(16));
    }

    private final void handleExceptionEvent(ExceptionEvent exceptionEvent) {
        EventObject eventObject = null;
        RequestSlave requestSlave = this;
        synchronized (requestSlave) {
            if (this.sawData) {
                eventObject = this.setState(14);
            } else {
                try {
                    exceptionEvent.rethrow();
                }
                catch (Exception exception) {
                    System.err.println("RequestSlave.handleExceptionEvent -- exception:" + exception);
                    exception.printStackTrace();
                    this.exceptions.push(exception);
                }
                System.err.println("RequestSlave.handleExceptionEvent -- failing!");
                eventObject = this.setState(16);
            }
        }
        this.fire(eventObject);
    }

    private void cleanUpFiles(boolean bl) throws IOException {
        File file;
        if (this.metaData != null && (file = ((FileBucket)this.metaData).getFile()).exists() && !file.delete()) {
            System.err.println("RequestSlave.cleanUpFiles -- couldn't remove: " + file.toString());
        }
        if (this.data != null) {
            file = ((FileBucket)this.data).getFile();
            if (file.exists() && bl && !this.skippedDownload && this.fileName != null) {
                if (!file.renameTo(new File(this.fileName))) {
                    System.err.println("RequestSlave.cleanUpFiles -- couldn't write: " + this.fileName);
                    throw new IOException("Couldn't rename temp file to: " + this.fileName);
                }
            } else if (file.exists() && !file.delete()) {
                System.err.println("RequestSlave.cleanUpFiles -- couldn't remove: " + file.toString());
            }
        }
    }

    private final boolean dumpingToBuckets() {
        return this.dataOut != null || this.metaDataOut != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void copyBucket(Bucket bucket, Bucket bucket2) throws IOException {
        if (bucket2 == null) {
            return;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            try {
                inputStream = bucket.getInputStream();
                outputStream = bucket2.getOutputStream();
                byte[] byArray = new byte[1024];
                int n = inputStream.read(byArray);
                while (n != -1) {
                    outputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
            }
            catch (IOException iOException) {
                RequestSlave.closeIgnoringE(inputStream);
                inputStream = null;
                RequestSlave.closeIgnoringE(outputStream);
                outputStream = null;
                throw iOException;
            }
            Object var8_8 = null;
            try {
                block13: {
                    try {
                        if (inputStream == null) break block13;
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        RequestSlave.closeIgnoringE(outputStream);
                        outputStream = null;
                        throw iOException;
                    }
                }
                Object var11_10 = null;
                if (outputStream == null) return;
                outputStream.close();
                return;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {}
            catch (Throwable throwable2) {
                Object var11_13 = null;
                if (outputStream == null) throw throwable2;
                outputStream.close();
                throw throwable2;
            }
            try {}
            catch (IOException iOException) {
                RequestSlave.closeIgnoringE(outputStream);
                outputStream = null;
                throw iOException;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            Object var11_12 = null;
            if (outputStream == null) throw throwable;
            outputStream.close();
            throw throwable;
        }
    }

    private static final void closeIgnoringE(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("RequestSlave.closeIgnoringE -- ignored: " + iOException);
        }
    }

    private static final void closeIgnoringE(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("RequestSlave.closeIgnoringE -- ignored: " + iOException);
        }
    }

    class RequestRunnableImpl
    implements Runnable {
        RequestRunnableImpl() {
        }

        /*
         * Loose catch block
         */
        public void run() {
            block36: {
                block33: {
                    File file;
                    if (RequestSlave.this.fileName != null && (file = new File(RequestSlave.this.fileName)).exists() && file.length() > 0L && !RequestSlave.this.overwrite) {
                        System.err.println("RequestSlave.RunnableImpl.run -- FAILED, file already exists!");
                        EventObject eventObject = null;
                        RequestSlave requestSlave = RequestSlave.this;
                        synchronized (requestSlave) {
                            RequestSlave.this.slaveThread = null;
                            eventObject = RequestSlave.this.setState(17);
                        }
                        RequestSlave.this.fire(eventObject);
                        return;
                    }
                    RequestSlave.this.requestToken = new DataRequest(RequestSlave.this.htl, RequestSlave.this.currentKey.getURI(), RequestSlave.this.metaData, RequestSlave.this.data);
                    block21: while (true) {
                        RequestSlave.this.requestToken.addEventListener(RequestSlave.this.clientEventListener);
                        RequestSlave.this.performRequest(RequestSlave.this.requestToken);
                        RequestSlave.this.waitForClientLibraryFinished();
                        switch (RequestSlave.this.state) {
                            case 18: {
                                RequestSlave.this.requestToken.removeEventListener(RequestSlave.this.clientEventListener);
                                if (!RequestSlave.this.autoRedirect) {
                                    RequestSlave.this.fire(RequestSlave.this.setState(14));
                                    break block21;
                                }
                                if (RequestSlave.this.nRedirects >= 25) {
                                    System.err.println("RequestSlave.RunnableImpl -- failing! Too many redirects.");
                                    RequestSlave.this.fire(RequestSlave.this.setState(16));
                                    break block21;
                                }
                                RequestSlave.this.requestToken = RequestSlave.this.getRedirect();
                                if (RequestSlave.this.state == 14) break block21;
                                if (RequestSlave.this.requestToken != null) continue block21;
                                System.err.println("RequestSlave.RunnableImpl -- failing! bad redirect");
                                RequestSlave.this.fire(RequestSlave.this.setState(16));
                                break block21;
                            }
                        }
                        break;
                    }
                    Object var6_6 = null;
                    if (RequestSlave.this.requestToken == null) break block33;
                    RequestSlave.this.requestToken.removeEventListener(RequestSlave.this.clientEventListener);
                }
                RequestSlave.this.requestToken = null;
                try {
                    if (RequestSlave.this.dumpingToBuckets() && RequestSlave.this.state == 14) {
                        RequestSlave.this.copyBucket(RequestSlave.this.data, RequestSlave.this.dataOut);
                        RequestSlave.this.copyBucket(RequestSlave.this.metaData, RequestSlave.this.metaDataOut);
                    }
                    RequestSlave.this.cleanUpFiles(RequestSlave.this.state == 14 && !RequestSlave.this.sawData && !RequestSlave.this.dumpingToBuckets());
                }
                catch (IOException serializable) {
                    System.err.println("RequestSlave.RunnableImpl -- UNEXPECTED EXCEPTION(1): " + serializable.toString());
                    RequestSlave.this.exceptions.push(serializable);
                    RequestSlave.this.fire(RequestSlave.this.setState(16));
                }
                RequestSlave.this.data = null;
                RequestSlave.this.metaData = null;
                serializable = null;
                RequestSlave requestSlave = RequestSlave.this;
                synchronized (requestSlave) {
                    if (RequestSlave.this.sawData && RequestSlave.this.haltCHK == null) {
                        RequestSlave.this.state = 14;
                    }
                    RequestSlave.this.slaveThread = null;
                    serializable = RequestSlave.this.state == 14 ? RequestSlave.this.setState(15) : RequestSlave.this.setState(17);
                }
                RequestSlave.this.fire((EventObject)serializable);
                {
                    break block36;
                    catch (IOException iOException) {
                        System.err.println("RequestSlave.RunnableImpl -- UNEXPECTED EXCEPTION: " + iOException.toString());
                        iOException.printStackTrace();
                        RequestSlave.this.exceptions.push(iOException);
                        RequestSlave.this.fire(RequestSlave.this.setState(16));
                        Object var6_7 = null;
                        if (RequestSlave.this.requestToken != null) {
                            RequestSlave.this.requestToken.removeEventListener(RequestSlave.this.clientEventListener);
                        }
                        RequestSlave.this.requestToken = null;
                        try {
                            if (RequestSlave.this.dumpingToBuckets() && RequestSlave.this.state == 14) {
                                RequestSlave.this.copyBucket(RequestSlave.this.data, RequestSlave.this.dataOut);
                                RequestSlave.this.copyBucket(RequestSlave.this.metaData, RequestSlave.this.metaDataOut);
                            }
                            RequestSlave.this.cleanUpFiles(RequestSlave.this.state == 14 && !RequestSlave.this.sawData && !RequestSlave.this.dumpingToBuckets());
                        }
                        catch (IOException serializable) {
                            System.err.println("RequestSlave.RunnableImpl -- UNEXPECTED EXCEPTION(1): " + serializable.toString());
                            RequestSlave.this.exceptions.push(serializable);
                            RequestSlave.this.fire(RequestSlave.this.setState(16));
                        }
                        RequestSlave.this.data = null;
                        RequestSlave.this.metaData = null;
                        serializable = null;
                        RequestSlave requestSlave2 = RequestSlave.this;
                        synchronized (requestSlave2) {
                            if (RequestSlave.this.sawData && RequestSlave.this.haltCHK == null) {
                                RequestSlave.this.state = 14;
                            }
                            RequestSlave.this.slaveThread = null;
                            serializable = RequestSlave.this.state == 14 ? RequestSlave.this.setState(15) : RequestSlave.this.setState(17);
                        }
                        RequestSlave.this.fire((EventObject)serializable);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (RequestSlave.this.requestToken != null) {
                        RequestSlave.this.requestToken.removeEventListener(RequestSlave.this.clientEventListener);
                    }
                    RequestSlave.this.requestToken = null;
                    try {
                        if (RequestSlave.this.dumpingToBuckets() && RequestSlave.this.state == 14) {
                            RequestSlave.this.copyBucket(RequestSlave.this.data, RequestSlave.this.dataOut);
                            RequestSlave.this.copyBucket(RequestSlave.this.metaData, RequestSlave.this.metaDataOut);
                        }
                        RequestSlave.this.cleanUpFiles(RequestSlave.this.state == 14 && !RequestSlave.this.sawData && !RequestSlave.this.dumpingToBuckets());
                    }
                    catch (IOException serializable) {
                        System.err.println("RequestSlave.RunnableImpl -- UNEXPECTED EXCEPTION(1): " + serializable.toString());
                        RequestSlave.this.exceptions.push(serializable);
                        RequestSlave.this.fire(RequestSlave.this.setState(16));
                    }
                    RequestSlave.this.data = null;
                    RequestSlave.this.metaData = null;
                    serializable = null;
                    RequestSlave requestSlave3 = RequestSlave.this;
                    synchronized (requestSlave3) {
                        if (RequestSlave.this.sawData && RequestSlave.this.haltCHK == null) {
                            RequestSlave.this.state = 14;
                        }
                        RequestSlave.this.slaveThread = null;
                        serializable = RequestSlave.this.state == 14 ? RequestSlave.this.setState(15) : RequestSlave.this.setState(17);
                    }
                    RequestSlave.this.fire((EventObject)serializable);
                    throw throwable;
                }
            }
        }
    }

    class RequestClientEventListenerImpl
    implements ClientEventListener {
        RequestClientEventListenerImpl() {
        }

        public void receive(ClientEvent clientEvent) {
            if (clientEvent instanceof StateReachedEvent) {
                int n = ((StateReachedEvent)clientEvent).getState();
                RequestSlave.this.handleStateReachedEvent((StateReachedEvent)clientEvent);
            } else if (clientEvent instanceof TransferStartedEvent) {
                RequestSlave.this.handleTransferStartedEvent((TransferStartedEvent)clientEvent);
            } else if (clientEvent instanceof TransferedEvent) {
                RequestSlave.this.handleTransferedEvent((TransferedEvent)clientEvent);
            } else if (clientEvent instanceof SegmentCompleteEvent) {
                RequestSlave.this.handleSegmentCompleteEvent((SegmentCompleteEvent)clientEvent);
            } else if (clientEvent instanceof RestartedEvent) {
                RequestSlave.this.handleRestartedEvent((RestartedEvent)clientEvent);
            } else if (clientEvent instanceof RequestCompleteEvent) {
                RequestSlave.this.handleRequestCompleteEvent((RequestCompleteEvent)clientEvent);
            } else if (clientEvent instanceof RequestFailedEvent) {
                RequestSlave.this.handleRequestFailedEvent((RequestFailedEvent)clientEvent);
            } else if (clientEvent instanceof NoReplyEvent) {
                RequestSlave.this.handleNoReplyEvent((NoReplyEvent)clientEvent);
            } else if (clientEvent instanceof ExceptionEvent) {
                RequestSlave.this.handleExceptionEvent((ExceptionEvent)clientEvent);
            } else if (clientEvent instanceof ErrorEvent) {
                RequestSlave.this.handleErrorEvent((ErrorEvent)clientEvent);
            }
        }
    }

    class TransferedEventDescendant
    extends TransferedEvent {
        public TransferedEventDescendant(TransferedEvent transferedEvent) {
            super(transferedEvent.getProgress());
        }
    }

    static class EventFirerImpl
    implements EventFirer {
        EventFirerImpl() {
        }

        public final boolean fireEvent(EventListener eventListener, EventObject eventObject) {
            if (eventObject instanceof RequestStatusEvent) {
                ((RequestSlaveListener)eventListener).requestStatus((RequestStatusEvent)eventObject);
            } else if (eventObject instanceof SlaveRestartedEvent) {
                ((RequestSlaveListener)eventListener).restarted((SlaveRestartedEvent)eventObject);
            } else {
                return false;
            }
            return true;
        }
    }
}

