/*
 * Decompiled with CFR 0.152.
 */
package relentless.gj.client.batch;

import Freenet.Core;
import Freenet.support.Fields;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import relentless.gj.client.SlaveBase;
import relentless.gj.util.EventDispatcher;

public abstract class BatchBase {
    public static final int WORKING = 1;
    public static final int SUCCEEDED = 2;
    public static final int FAILED = 3;
    protected int slaveCount = -1;
    protected volatile Vector taskQueue = new Vector();
    protected volatile Vector availableSlaves = new Vector();
    protected volatile boolean run = true;
    protected volatile Thread executor = null;
    private volatile int intertaskPauseMs = 50;
    protected EventDispatcher dispatcher = null;
    static File tmpDir = null;

    public int working() {
        Vector vector = this.availableSlaves;
        synchronized (vector) {
            int n = this.slaveCount - this.availableSlaves.size();
            return n;
        }
    }

    public int queued() {
        return this.taskQueue.size();
    }

    public abstract void abortAll();

    public final void setEventDispatcher(EventDispatcher eventDispatcher) {
        eventDispatcher.setFirer(this.dispatcher.getFirer());
        this.dispatcher = eventDispatcher;
    }

    public static synchronized void createTmpDir(String string) throws IOException {
        File file;
        if (string.equals("")) {
            string = ".";
        }
        if (!(file = new File(string)).exists() || !file.isDirectory()) {
            IOException iOException = new IOException("Root directory doesn't exist: " + file.getAbsolutePath());
            tmpDir = null;
            throw iOException;
        }
        tmpDir = new File(file, "bb_tmp_" + Fields.longToString((long)Math.abs(Core.randSource.nextInt())));
        if (!(tmpDir.exists() && tmpDir.isDirectory() || tmpDir.mkdirs())) {
            IOException iOException = new IOException("Couldn't create temp directory: " + tmpDir.getAbsolutePath());
            tmpDir = null;
            throw iOException;
        }
        SlaveBase.setTmpDir(tmpDir);
    }

    public static synchronized void removeTmpDir() throws IOException {
        if (tmpDir == null) {
            return;
        }
        String[] stringArray = tmpDir.list();
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(tmpDir, stringArray[n]);
            if (file.isFile()) {
                file.delete();
            }
            ++n;
        }
        if (!tmpDir.delete()) {
            throw new IOException("Couldn't delete directory: " + tmpDir.getAbsolutePath());
        }
    }

    protected TaskInfo makeTaskInfo(Object object) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.task = object;
        return taskInfo;
    }

    protected abstract boolean startTask(Object var1, TaskInfo var2);

    protected void queue(Object object) {
        Vector vector = this.taskQueue;
        synchronized (vector) {
            TaskInfo taskInfo = this.makeTaskInfo(object);
            this.taskQueue.addElement(taskInfo);
            this.taskQueue.notifyAll();
        }
    }

    protected void releaseSlave(Object object) {
        Vector vector = this.availableSlaves;
        synchronized (vector) {
            if (this.availableSlaves.contains(object)) {
                throw new IllegalArgumentException("slave not allocated!");
            }
            this.availableSlaves.addElement(object);
            this.availableSlaves.notifyAll();
        }
    }

    protected synchronized boolean isRunning() {
        return this.executor != null;
    }

    protected synchronized void start() {
        if (this.executor != null) {
            throw new RuntimeException("Task executor thread is already running!");
        }
        this.run = true;
        this.executor = new Thread((Runnable)new TaskRunner(), "BatchBase -- task excecutor thread");
        this.executor.start();
    }

    protected synchronized void stop() {
        this.run = false;
        if (this.executor != null) {
            this.executor.interrupt();
        }
    }

    protected synchronized void flush() {
        if (this.executor != null) {
            throw new RuntimeException("Can't flush while task executor thread running!");
        }
        Vector vector = this.taskQueue;
        synchronized (vector) {
            this.taskQueue.removeAllElements();
            this.taskQueue.notifyAll();
        }
    }

    protected void setIntertaskPauseMS(int n) {
        this.intertaskPauseMs = n;
    }

    class TaskRunner
    implements Runnable {
        TaskRunner() {
        }

        public void run() {
            BatchBase batchBase;
            try {
                TaskInfo taskInfo = null;
                while (BatchBase.this.run) {
                    try {
                        Vector vector = BatchBase.this.taskQueue;
                        synchronized (vector) {
                            while (BatchBase.this.taskQueue.size() < 1) {
                                BatchBase.this.taskQueue.wait();
                            }
                            taskInfo = (TaskInfo)BatchBase.this.taskQueue.firstElement();
                            BatchBase.this.taskQueue.removeElement(taskInfo);
                        }
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        Vector vector2 = BatchBase.this.availableSlaves;
                        synchronized (vector2) {
                            while (BatchBase.this.availableSlaves.size() < 1) {
                                BatchBase.this.availableSlaves.wait();
                            }
                            taskInfo.slave = BatchBase.this.availableSlaves.firstElement();
                            BatchBase.this.availableSlaves.removeElement(taskInfo.slave);
                        }
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        if (!BatchBase.this.startTask(taskInfo.slave, taskInfo)) {
                            BatchBase.this.releaseSlave(taskInfo.slave);
                            taskInfo.slave = null;
                        }
                        if (BatchBase.this.intertaskPauseMs > 0) {
                            Thread.sleep(BatchBase.this.intertaskPauseMs);
                        }
                        taskInfo = null;
                    }
                    catch (InterruptedException interruptedException) {
                        if (BatchBase.this.run || taskInfo == null) break;
                        if (taskInfo.slave != null) {
                            BatchBase.this.releaseSlave(taskInfo.slave);
                            taskInfo.slave = null;
                        }
                        BatchBase.this.taskQueue.addElement(taskInfo);
                        taskInfo = null;
                        break;
                    }
                }
                Object var6_7 = null;
                batchBase = BatchBase.this;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                BatchBase batchBase2 = BatchBase.this;
                synchronized (batchBase2) {
                    BatchBase.this.executor = null;
                    BatchBase.this.notifyAll();
                }
                throw throwable;
            }
            synchronized (batchBase) {
                BatchBase.this.executor = null;
                BatchBase.this.notifyAll();
            }
        }
    }

    protected static class TaskInfo {
        protected Object task = null;
        protected Object slave = null;
        protected int retries = 0;

        protected TaskInfo() {
        }
    }
}

